/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.antlr.xjlib.appkit.frame.XJDialog;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;

public class XJDialogProgress
extends XJDialog {
    protected XJDialogProgressDelegate delegate;
    protected JLabel infoLabel;
    protected JProgressBar progressBar;
    protected JButton cancelButton;

    public XJDialogProgress(XJFrameInterface xJFrameInterface, boolean bl) {
        super(xJFrameInterface == null ? null : xJFrameInterface.getJavaContainer(), bl);
        this.init();
    }

    public XJDialogProgress(XJFrameInterface xJFrameInterface) {
        super(xJFrameInterface == null ? null : xJFrameInterface.getJavaContainer(), false);
        this.init();
    }

    public XJDialogProgress(Container container, boolean bl) {
        super(container, bl);
        this.init();
    }

    public XJDialogProgress(Container container) {
        super(container, false);
        this.init();
    }

    public void init() {
        this.setResizable(false);
        this.setSize(400, 90);
        this.initComponents();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJDialogProgress.this.delegate != null) {
                    XJDialogProgress.this.setInfo("Cancelling...");
                    XJDialogProgress.this.delegate.dialogDidCancel();
                }
            }
        });
    }

    public void setCancellable(boolean bl) {
        this.cancelButton.setEnabled(bl);
    }

    public void setIndeterminate(boolean bl) {
        if (bl) {
            this.setProgress(0);
            this.setProgressMax(0);
        }
        this.progressBar.setIndeterminate(bl);
    }

    public void setDelegate(XJDialogProgressDelegate xJDialogProgressDelegate) {
        this.delegate = xJDialogProgressDelegate;
    }

    public void setInfo(String string) {
        this.infoLabel.setText(string);
    }

    public void setProgress(float f) {
        this.setProgress((int)f);
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void setProgressMax(int n) {
        this.progressBar.setMaximum(n);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.infoLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton("Cancel");
        this.setTitle("Operation in progress");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        container.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 20, 20, 10);
        container.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 20);
        container.add((Component)this.cancelButton, gridBagConstraints);
    }
}

