/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.update;

import java.awt.Container;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.update.XJUpdateManagerDelegate;
import org.antlr.xjlib.appkit.update.XJUpdateManagerDialogUpdateAvailable;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJDialogProgress;
import org.antlr.xjlib.appkit.utils.XJDialogProgressDelegate;
import org.antlr.xjlib.foundation.XJUtils;

public class XJUpdateManager {
    public static final String KEY_VERSION = "KEY_VERSION";
    public static final String KEY_APP_NAME = "KEY_APP_NAME";
    public static final String KEY_DESCRIPTION = "KEY_DESCRIPTION";
    public static final String KEY_DOWNLOAD_FILE_URL = "KEY_DOWNLOAD_FILE_URL";
    public static final String KEY_DOWNLOAD_FILE_NAME = "KEY_DOWNLOAD_FILE_NAME";
    public static final String KEY_DOWNLOAD_SIZE = "KEY_DOWNLOAD_SIZE";
    protected Container parent;
    protected XJUpdateManagerDelegate delegate;
    protected Map updateInfoMap;
    protected boolean cancelDownload = false;

    public XJUpdateManager(Container container, XJUpdateManagerDelegate xJUpdateManagerDelegate) {
        this.parent = container == null ? XJApplication.getActiveContainer() : container;
        this.delegate = xJUpdateManagerDelegate == null ? new DefaultDownloadUpdateDelegate() : xJUpdateManagerDelegate;
    }

    public Container getParentContainer() {
        return this.parent;
    }

    public String getApplicationName() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_APP_NAME);
    }

    public String getDownloadVersion() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_VERSION);
    }

    public String getDownloadFileName() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DOWNLOAD_FILE_NAME);
    }

    public String getDownloadFileURL() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DOWNLOAD_FILE_URL);
    }

    public long getDownloadSize() {
        if (this.updateInfoMap == null) {
            return 0L;
        }
        return (Long)this.updateInfoMap.get(KEY_DOWNLOAD_SIZE);
    }

    public String getDescription() {
        if (this.updateInfoMap == null) {
            return null;
        }
        return (String)this.updateInfoMap.get(KEY_DESCRIPTION);
    }

    public boolean writeUpdateXMLFile(String string, String string2, String string3, String string4, String string5, long l, String string6) {
        XMLEncoder xMLEncoder;
        try {
            xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(string6)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot write the update xml file because:\n" + fileNotFoundException);
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(KEY_VERSION, string);
        hashMap.put(KEY_APP_NAME, string2);
        hashMap.put(KEY_DESCRIPTION, string3);
        hashMap.put(KEY_DOWNLOAD_FILE_NAME, string4);
        hashMap.put(KEY_DOWNLOAD_FILE_URL, string5);
        hashMap.put(KEY_DOWNLOAD_SIZE, l);
        xMLEncoder.writeObject(hashMap);
        xMLEncoder.close();
        return true;
    }

    public void downloadUpdateToLocalDisk(String string) {
        this.downloadUpdateToLocalDisk(this.getDownloadFileURL(), string);
    }

    public void downloadUpdateToLocalDisk(String string, String string2) {
        InputStream inputStream;
        URL uRL;
        BufferedOutputStream bufferedOutputStream;
        new File(string2).delete();
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + fileNotFoundException);
            return;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + malformedURLException);
            return;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot download the update because:\n" + iOException);
            return;
        }
        this.delegate.umDownloadBegin();
        new Thread(new BackgroundDownloader(inputStream, bufferedOutputStream, string2)).start();
    }

    public void fetchRemoteUpdateInformation(String string, boolean bl) {
        InputStream inputStream;
        URL uRL;
        this.updateInfoMap = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (!bl) {
                XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + malformedURLException);
            }
            return;
        }
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            if (!bl) {
                XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + iOException);
            }
            return;
        }
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream));
        try {
            this.updateInfoMap = (Map)xMLDecoder.readObject();
        }
        catch (Exception exception) {
            XJAlert.display(this.getParentContainer(), "Update Manager", "Cannot check the update because:\n" + exception);
            return;
        }
        xMLDecoder.close();
    }

    public boolean isUpdateAvailable(String string) {
        if (this.updateInfoMap == null) {
            return false;
        }
        return XJUtils.isVersionGreaterThan(this.getDownloadVersion(), string);
    }

    public void cancelDownload() {
        this.setCancelDownload(true);
    }

    public synchronized void setCancelDownload(boolean bl) {
        this.cancelDownload = bl;
    }

    public boolean isCancelDownload() {
        return this.cancelDownload;
    }

    public void checkForUpdates(String string, String string2, String string3, boolean bl) {
        this.fetchRemoteUpdateInformation(string2, bl);
        if (this.isUpdateAvailable(string)) {
            if (new XJUpdateManagerDialogUpdateAvailable(this).runModal() == 1) {
                this.downloadUpdateToLocalDisk(XJUtils.concatPath(string3, this.getDownloadFileName()));
            }
        } else if (this.updateInfoMap != null && !bl) {
            XJAlert.display(this.getParentContainer(), "Check for Updates", "You already have the latest version.\nCheck again later.");
        }
    }

    protected class BackgroundDownloader
    implements Runnable {
        protected InputStream is;
        protected OutputStream os;
        protected String localDownloadFile;

        public BackgroundDownloader(InputStream inputStream, OutputStream outputStream, String string) {
            this.is = inputStream;
            this.os = outputStream;
            this.localDownloadFile = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] byArray = new byte[8192];
            long l = 0L;
            long l2 = XJUpdateManager.this.getDownloadSize();
            try {
                int n;
                while ((n = this.is.read(byArray)) > 0 && !XJUpdateManager.this.isCancelDownload()) {
                    XJUpdateManager.this.delegate.umDownloadProgress(l += (long)n, l2);
                    this.os.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
                try {
                    this.os.close();
                }
                catch (IOException iOException) {}
                if (XJUpdateManager.this.isCancelDownload()) {
                    XJUpdateManager.this.delegate.umDownloadCancelled();
                } else {
                    XJUpdateManager.this.delegate.umDownloadCompleted(this.localDownloadFile);
                }
            }
        }
    }

    protected class DefaultDownloadUpdateDelegate
    extends XJUpdateManagerDelegate
    implements XJDialogProgressDelegate {
        protected XJDialogProgress progress;

        protected DefaultDownloadUpdateDelegate() {
        }

        public void umDownloadBegin() {
            this.progress = new XJDialogProgress(XJUpdateManager.this.parent);
            this.progress.setInfo("Downloading...");
            this.progress.setProgress(0);
            this.progress.setProgressMax(100);
            this.progress.setDelegate(this);
            this.progress.display();
        }

        public void umDownloadProgress(long l, long l2) {
            this.progress.setProgress((float)l / (float)l2 * 100.0f);
        }

        public void umDownloadCancelled() {
            this.progress.close();
            XJAlert.display(XJUpdateManager.this.getParentContainer(), "Check for Updates", "The download has been cancelled.");
        }

        public void umDownloadCompleted(String string) {
            this.progress.close();
            XJAlert.display(XJUpdateManager.this.getParentContainer(), "Check for Updates", "The new version has been downloaded and is available here:\n" + string);
        }

        public void dialogDidCancel() {
            XJUpdateManager.this.cancelDownload();
        }
    }
}

