/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.undo;

import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTextPane;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;

public class XJUndoEngine {
    protected XJMainMenuBar mainMenuBar;
    protected Map<JTextPane, XJUndo> undos = new HashMap<JTextPane, XJUndo>();

    public void setMainMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.mainMenuBar = xJMainMenuBar;
    }

    public void registerUndo(XJUndo xJUndo, JTextPane jTextPane) {
        xJUndo.bindTo(jTextPane);
        jTextPane.addFocusListener(new EditorFocusListener());
        this.undos.put(jTextPane, xJUndo);
    }

    public void unregisterUndo(XJUndoDelegate xJUndoDelegate) {
        for (JTextPane jTextPane : new HashSet<JTextPane>(this.undos.keySet())) {
            XJUndo xJUndo = this.undos.get(jTextPane);
            if (xJUndo.delegate != xJUndoDelegate) continue;
            xJUndo.close();
            this.undos.remove(jTextPane);
            for (FocusListener focusListener : jTextPane.getFocusListeners()) {
                jTextPane.removeFocusListener(focusListener);
            }
        }
    }

    public XJUndo getCurrentUndo() {
        return this.undos.get(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner());
    }

    public XJUndo getUndo(Object object) {
        return this.undos.get(object);
    }

    public void updateUndoRedo(Object object) {
        XJUndo xJUndo = this.getUndo(object);
        this.updateUndoRedo(xJUndo);
    }

    public void updateUndoRedo(XJUndo xJUndo) {
        if (this.mainMenuBar != null) {
            this.mainMenuBar.menuUndoRedoItemState(this.getCurrentUndo());
        }
    }

    public void undoStateDidChange(XJUndo xJUndo) {
        this.updateUndoRedo(xJUndo);
    }

    protected class EditorFocusListener
    implements FocusListener {
        protected EditorFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            XJUndoEngine.this.updateUndoRedo(focusEvent.getSource());
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                XJUndoEngine.this.updateUndoRedo(null);
            }
        }
    }
}

