/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.undo;

import java.util.Stack;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.antlr.xjlib.appkit.undo.XJRedoAction;
import org.antlr.xjlib.appkit.undo.XJUndoAction;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.undo.XJUndoEngine;

public class XJUndo {
    protected XJUndoEngine engine;
    protected XJUndoDelegate delegate;
    protected UndoManager undoManager = new UndoManager();
    protected XJUndoAction undoAction;
    protected XJRedoAction redoAction;
    protected Stack<CustomCompoundEdit> groupEditEvent = new Stack();
    protected int enable = 0;

    public XJUndo(XJUndoEngine xJUndoEngine, XJUndoDelegate xJUndoDelegate) {
        this.engine = xJUndoEngine;
        this.delegate = xJUndoDelegate;
        this.undoAction = new XJUndoAction(this.undoManager);
        this.redoAction = new XJRedoAction(this.undoManager);
        this.undoAction.setRedoAction(this.redoAction);
        this.redoAction.setUndoAction(this.undoAction);
    }

    public void close() {
        this.engine = null;
        this.delegate = null;
    }

    public void bindTo(JTextPane jTextPane) {
        jTextPane.getDocument().addUndoableEditListener(new TextPaneUndoableEditListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performUndo() {
        if (this.delegate != null) {
            this.delegate.undoManagerWillUndo(false);
        }
        try {
            this.undoAction.actionPerformed(null);
            this.fireUndoStateDidChange();
        }
        finally {
            if (this.delegate != null) {
                this.delegate.undoManagerDidUndo(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRedo() {
        if (this.delegate != null) {
            this.delegate.undoManagerWillUndo(true);
        }
        try {
            this.redoAction.actionPerformed(null);
            this.fireUndoStateDidChange();
        }
        finally {
            if (this.delegate != null) {
                this.delegate.undoManagerDidUndo(true);
            }
        }
    }

    public void beginUndoGroup(String string) {
        this.groupEditEvent.push(new CustomCompoundEdit(string));
    }

    public void endUndoGroup() {
        CustomCompoundEdit customCompoundEdit = this.groupEditEvent.pop();
        customCompoundEdit.end();
        this.addEditEvent(customCompoundEdit);
    }

    public CompoundEdit getUndoGroup() {
        if (this.groupEditEvent.isEmpty()) {
            return null;
        }
        return this.groupEditEvent.peek();
    }

    public void enableUndo() {
        --this.enable;
    }

    public void disableUndo() {
        ++this.enable;
    }

    public boolean isEnabled() {
        return this.enable == 0;
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public void addEditEvent(UndoableEdit undoableEdit) {
        this.undoManager.addEdit(undoableEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        this.fireUndoStateDidChange();
    }

    protected void fireUndoStateDidChange() {
        this.engine.undoStateDidChange(this);
    }

    protected static class CustomCompoundEdit
    extends CompoundEdit {
        protected String name;

        public CustomCompoundEdit(String string) {
            this.name = string;
        }

        public String getUndoPresentationName() {
            return "Undo " + this.name;
        }

        public String getRedoPresentationName() {
            return "Redo " + this.name;
        }
    }

    protected class TextPaneUndoableEditListener
    implements UndoableEditListener {
        protected TextPaneUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            if (!XJUndo.this.isEnabled()) {
                return;
            }
            CompoundEdit compoundEdit = XJUndo.this.getUndoGroup();
            if (compoundEdit == null) {
                XJUndo.this.addEditEvent(undoableEditEvent.getEdit());
            } else {
                compoundEdit.addEdit(undoableEditEvent.getEdit());
            }
        }
    }
}

