/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.text;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import org.antlr.xjlib.appkit.utils.BrowserLauncher;

public class XJURLLabel
extends JLabel {
    protected String url;
    protected ActionListener listener;
    protected Color unvisitedURL = Color.blue;
    protected Color visitedURL = Color.blue;

    public XJURLLabel() {
        this.setForeground(this.unvisitedURL);
        this.addMouseListener(new Clicked());
    }

    public XJURLLabel(String string) {
        this();
        this.url = string;
    }

    public XJURLLabel(ActionListener actionListener) {
        this();
        this.listener = actionListener;
    }

    public void setUnvisitedURLColor(Color color) {
        this.unvisitedURL = color;
        this.setForeground(this.unvisitedURL);
    }

    public void setVisitedURLColor(Color color) {
        this.visitedURL = color;
    }

    class Clicked
    extends MouseAdapter {
        Clicked() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            XJURLLabel.this.setForeground(XJURLLabel.this.visitedURL);
            try {
                if (XJURLLabel.this.listener != null) {
                    XJURLLabel.this.listener.actionPerformed(new ActionEvent(this, 0, ""));
                }
                if (XJURLLabel.this.url != null) {
                    BrowserLauncher.openURL(XJURLLabel.this.url);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            XJURLLabel.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            XJURLLabel.this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

