/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.antlr.xjlib.appkit.swing.XJTreeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJTree
extends JTree
implements DragGestureListener,
DropTargetListener,
DragSourceListener,
Autoscroll {
    protected XJTreeDelegate delegate;
    protected DragSource dragSource;
    protected DropTarget dt;
    protected TreePath oldSelectedPath;
    protected Timer autoExpandTimer;
    protected TreePath lastPath;
    protected Point lastPoint = new Point();
    protected Rectangle cueLine = new Rectangle();
    protected BufferedImage dragImage;
    protected Point dragImageOffset = new Point();
    protected final int AUTOSCROLL_MARGIN = 12;
    protected int dropLocation;
    public static final int DROP_ABOVE = 0;
    public static final int DROP_ONTO = 1;
    public static final int DROP_BELOW = 2;

    public XJTree() {
        this.autoExpandTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJTree.this.isRootVisible() && XJTree.this.getRowForPath(XJTree.this.lastPath) == 0) {
                    return;
                }
                if (XJTree.this.isExpanded(XJTree.this.lastPath)) {
                    XJTree.this.collapsePath(XJTree.this.lastPath);
                } else {
                    XJTree.this.expandPath(XJTree.this.lastPath);
                }
            }
        });
        this.autoExpandTimer.setRepeats(false);
    }

    public void close() {
        this.autoExpandTimer.stop();
        this.autoExpandTimer = null;
        this.dragSource = null;
        this.dt = null;
    }

    public void setDelegate(XJTreeDelegate xJTreeDelegate) {
        this.delegate = xJTreeDelegate;
    }

    public void setEnableDragAndDrop() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, this.getDelegateConstants(), this);
        this.dt = new DropTarget(this, this);
    }

    public int getDelegateConstants() {
        return this.delegate.xjTreeDragAndDropConstants(this);
    }

    public DefaultMutableTreeNode getOldSelectedNode() {
        return (DefaultMutableTreeNode)this.oldSelectedPath.getLastPathComponent();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
    }

    public List<Object> getSelectedNodes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.getSelectionPaths() != null) {
            for (int i = 0; i < this.getSelectionPaths().length; ++i) {
                TreePath treePath = this.getSelectionPaths()[i];
                arrayList.add(treePath.getLastPathComponent());
            }
        }
        return arrayList;
    }

    public void modifySelectionIfNecessary(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.getSelectionRows() != null) {
            for (int i = 0; i < this.getSelectionRows().length; ++i) {
                int n2 = this.getSelectionRows()[i];
                if (n2 != n) continue;
                bl = true;
            }
        }
        if (!bl) {
            this.setSelectionRow(n);
        }
    }

    protected void cleanUpAfterDrag() {
        this.paintImmediately(this.cueLine);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + 12, rectangle2.x - rectangle.x + 12, rectangle.height - rectangle2.height + 12, rectangle.width - rectangle2.width + 12);
    }

    @Override
    public void autoscroll(Point point) {
        int n = this.getRowForLocation(point.x, point.y);
        if (n < 0) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        n = point.y + rectangle.y <= 12 ? (n <= 0 ? 0 : n - 1) : (n < this.getRowCount() - 1 ? n + 1 : n);
        this.scrollRowToVisible(n);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        try {
            this.createDragImage(dragGestureEvent);
            this.dragSource.startDrag(dragGestureEvent, this.delegate.xjTreeDragSourceDefaultCursor(this), this.dragImage, new Point(5, 5), (Transferable)this.getSelectedNode().getUserObject(), this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createDragImage(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        Rectangle rectangle = this.getPathBounds(treePath);
        this.dragImageOffset.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        JLabel jLabel = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, this.isExpanded(treePath), this.getModel().isLeaf(treePath.getLastPathComponent()), 0, false);
        jLabel.setSize(rectangle.width, rectangle.height);
        this.dragImage = new BufferedImage(rectangle.width, rectangle.height, 3);
        Graphics2D graphics2D = this.dragImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.paint(graphics2D);
        graphics2D.dispose();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.oldSelectedPath = this.getSelectionPath();
        if (dropTargetDragEvent.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(this.getDelegateConstants());
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = dropTargetDragEvent.getLocation().x;
        int n2 = dropTargetDragEvent.getLocation().y;
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != this.lastPath) {
            this.lastPath = treePath;
            this.autoExpandTimer.restart();
        }
        if (treePath == null || dropTargetDragEvent.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(this.getDelegateConstants());
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            Rectangle rectangle = this.getPathBounds(this.lastPath);
            Rectangle rectangle2 = (Rectangle)this.cueLine.clone();
            if (n2 < rectangle.y + rectangle.height / 2) {
                if (this.getRowForPath(this.lastPath) == 0) {
                    this.cueLine.setRect(0.0, rectangle.y, this.getWidth(), 2.0);
                } else {
                    this.cueLine.setRect(0.0, rectangle.y - 1, this.getWidth(), 2.0);
                }
                this.dropLocation = 0;
            } else {
                this.cueLine.setRect(0.0, rectangle.y + rectangle.height - 1, this.getWidth(), 2.0);
                this.dropLocation = 2;
            }
            if (!rectangle2.equals(this.cueLine)) {
                this.paintImmediately(rectangle2);
            }
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.cueLine);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.getDropAction() != this.getDelegateConstants()) {
            this.cleanUpAfterDrag();
            dropTargetDragEvent.rejectDrag();
        } else {
            dropTargetDragEvent.acceptDrag(this.getDelegateConstants());
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.cleanUpAfterDrag();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.autoExpandTimer.stop();
        int n = (int)dropTargetDropEvent.getLocation().getX();
        int n2 = (int)dropTargetDropEvent.getLocation().getY();
        int n3 = this.getRowForLocation(n, n2);
        if (n3 == -1) {
            this.cleanUpAfterDrag();
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = ((DefaultMutableTreeNode)this.getPathForRow(n3).getLastPathComponent()).getUserObject();
        if (this.delegate.xjTreeDrop(this, this.getOldSelectedNode().getUserObject(), object, this.dropLocation)) {
            this.scrollPathToVisible(this.getPathForLocation(n, n2));
            dropTargetDropEvent.acceptDrop(this.getDelegateConstants());
            dropTargetDropEvent.dropComplete(true);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
        this.cleanUpAfterDrag();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }
}

