/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.antlr.xjlib.appkit.swing.XJTable;
import org.antlr.xjlib.appkit.swing.XJTableAlternateRenderer;
import org.antlr.xjlib.foundation.XJSystem;

public class XJTableView
extends JScrollPane {
    private XJTable table = new XJTable();
    private boolean alternateBackground = true;

    public XJTableView() {
        this.setViewportView(this.table);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                XJTableView.this.autoresizeColumns();
            }
        });
        this.table.setDefaultRenderer(Object.class, new XJTableAlternateRenderer());
        this.table.setShowGrid(false);
        this.table.setAutoResizeMode(0);
        this.setWheelScrollingEnabled(true);
        this.getViewport().setBackground(Color.white);
    }

    public XJTable getTable() {
        return this.table;
    }

    public boolean isAlternateBackground() {
        return this.alternateBackground;
    }

    public void setAlternateBackground(boolean bl) {
        this.alternateBackground = bl;
        if (bl) {
            this.table.setDefaultRenderer(Object.class, new XJTableAlternateRenderer());
        } else {
            this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        }
    }

    public void autoresizeColumns() {
        int n;
        XJTableView.resizeTableColumnsToFitContent(this.table, 20);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n2 = 0;
        for (n = 0; n < tableColumnModel.getColumnCount() - 1; ++n) {
            n2 += tableColumnModel.getColumn(n).getPreferredWidth();
        }
        n = this.getVerticalScrollBar().isVisible() ? (XJSystem.isWindows() ? 20 : 20) : (XJSystem.isWindows() ? 3 : 4);
        int n3 = this.getWidth();
        if (n3 == 0) {
            n3 = this.getPreferredSize().width;
        }
        if (tableColumnModel.getColumnCount() > 0) {
            TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1);
            int n4 = tableColumn.getPreferredWidth();
            tableColumn.setPreferredWidth(Math.max(n3 - n2 - n, n4));
        }
    }

    public static void resizeTableColumnsToFitContent(JTable jTable, int n) {
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            XJTableView.resizeColumnToFitContent(jTable, i, n);
        }
    }

    public static void resizeColumnToFitContent(JTable jTable, int n, int n2) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        int n3 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            tableCellRenderer = jTable.getCellRenderer(i, n);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n3 + n2);
    }

    public void scrollToLastRow() {
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }
}

