/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.antlr.xjlib.appkit.swing.XJTableDelegate;

public class XJTable
extends JTable
implements Autoscroll {
    private int margin = 12;
    public XJTableDelegate delegate;
    public int selectionRow = -1;
    public boolean ignoreSelectionEvent = false;
    public boolean allowEmptySelection = true;
    public boolean rememberSelection = false;
    public boolean autoresizeColumn = false;

    public XJTable() {
        this.init();
    }

    public XJTable(DefaultTableModel defaultTableModel) {
        super(defaultTableModel);
        this.init();
    }

    public void init() {
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!XJTable.this.ignoreSelectionEvent) {
                    XJTable.this.setSelectedRow(XJTable.this.getSelectedRow());
                    if (XJTable.this.delegate != null) {
                        XJTable.this.delegate.tableSelectionChanged(XJTable.this, XJTable.this.selectionRow);
                    }
                }
            }
        });
    }

    public void setDelegate(XJTableDelegate xJTableDelegate) {
        this.delegate = xJTableDelegate;
    }

    public void setAllowEmptySelection(boolean bl) {
        this.allowEmptySelection = bl;
    }

    public void setRememberSelection(boolean bl) {
        this.rememberSelection = bl;
    }

    public void setAutoresizeColumn(boolean bl) {
        this.autoresizeColumn = bl;
    }

    public void setSelectedRow(int n) {
        if (n == -1 && !this.allowEmptySelection) {
            n = 0;
        }
        this.selectionRow = Math.min(n, this.getRowCount() - 1);
        if (this.selectionRow >= 0) {
            this.setRowSelectionInterval(this.selectionRow, this.selectionRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.ignoreSelectionEvent = true;
        try {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
            defaultTableModel.fireTableDataChanged();
            this.setSelectedRow(this.selectionRow);
        }
        finally {
            this.ignoreSelectionEvent = false;
        }
    }

    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getParent().getBounds();
        return new Insets(rectangle2.y - rectangle.y + this.margin, rectangle2.x - rectangle.x + this.margin, rectangle.height - rectangle2.height + this.margin, rectangle.width - rectangle2.width + this.margin);
    }

    public void autoscroll(Point point) {
        int n = this.rowAtPoint(point);
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.getCellRect(point.y + rectangle.y <= this.margin ? n - 1 : n + 1, 0, true);
        this.scrollRectToVisible(rectangle2);
    }

    public void selectLastRow() {
        this.setSelectedRow(this.getRowCount() - 1);
        this.scrollRectToVisible(this.getCellRect(this.getRowCount() - 1, 0, true));
    }
}

