/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.antlr.xjlib.foundation.XJSystem;

public class XJLookAndFeel {
    public static String applyLookAndFeel(String string) {
        Frame[] frameArray;
        String string2 = XJLookAndFeel.getLookAndFeelClassName(string);
        if (string2 == null) {
            System.err.println("No LAF class name for name '" + string + "', using default LAF.");
            string2 = XJLookAndFeel.getLookAndFeelClassName(null);
        }
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (Frame frame : frameArray = Frame.getFrames()) {
            SwingUtilities.updateComponentTreeUI(frame);
            frame.pack();
        }
        return XJLookAndFeel.getLookAndFeelName(string2);
    }

    public static String getLookAndFeelClassName(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        if (string == null) {
            if (XJSystem.isLinux()) {
                return UIManager.getCrossPlatformLookAndFeelClassName();
            }
            return UIManager.getSystemLookAndFeelClassName();
        }
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getName().equalsIgnoreCase(string)) continue;
            return lookAndFeelInfo.getClassName();
        }
        return null;
    }

    public static String getLookAndFeelName(String string) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getClassName().equalsIgnoreCase(string)) continue;
            return lookAndFeelInfo.getName();
        }
        return null;
    }

    public static String getDefaultLookAndFeelName() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        String string = UIManager.getSystemLookAndFeelClassName();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelInfo.getClassName().equalsIgnoreCase(string)) continue;
            return lookAndFeelInfo.getName();
        }
        return string;
    }
}

