/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;

public class XJGraphics2DPS
extends Graphics2D {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected StringBuffer ps = new StringBuffer();
    protected Font font;
    protected Color color;
    protected Color background;
    protected Stroke stroke;
    protected AffineTransform transform;
    protected FontRenderContext fontRenderContext;
    protected Point upperLeftCorner = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Point lowerRightCorner = new Point();
    protected DecimalFormat df;
    protected int marginWidth;
    protected int marginHeight;
    protected static final int BytesPerComponent = 1;
    protected static final int BitsPerComponent = 8;
    protected static final int ComponentsPerPixel = 3;
    protected static char[] hexmap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public XJGraphics2DPS() {
        this.transform = new AffineTransform();
        this.fontRenderContext = new FontRenderContext(null, false, true);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        this.df = new DecimalFormat("###.##", decimalFormatSymbols);
        this.setFont(null);
        this.setStroke(new BasicStroke());
        this.setMargins(0, 0);
    }

    public void setMargins(int n, int n2) {
        this.marginWidth = n;
        this.marginHeight = n2;
    }

    public String redefineOperator(String string, String string2) {
        return "/" + string + " { " + string2 + " } bind def" + NEWLINE;
    }

    public String getPSText() {
        this.lowerRightCorner.x += this.marginWidth;
        this.lowerRightCorner.y += this.marginHeight;
        this.upperLeftCorner.x -= this.marginWidth;
        this.upperLeftCorner.y -= this.marginHeight;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%!PS-Adobe-3.0 EPSF-3.0");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%Creator: XJGraphics2DPS (c) 2005 by Jean Bovet and Terence Parr");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%BoundingBox: 0 0 ");
        stringBuffer.append(this.lowerRightCorner.x - this.upperLeftCorner.x);
        stringBuffer.append(" ");
        stringBuffer.append(this.lowerRightCorner.y - this.upperLeftCorner.y);
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%Origin: 0 0");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%Pages: 1");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%Page: 1 1");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("%%EndComments");
        stringBuffer.append(NEWLINE);
        stringBuffer.append(this.redefineOperator("tr", "translate"));
        stringBuffer.append(this.redefineOperator("sc", "scale"));
        stringBuffer.append(this.redefineOperator("gs", "gsave"));
        stringBuffer.append(this.redefineOperator("gr", "grestore"));
        stringBuffer.append(this.redefineOperator("m", "moveto"));
        stringBuffer.append(this.redefineOperator("l", "lineto"));
        stringBuffer.append(this.redefineOperator("c", "curveto"));
        stringBuffer.append(this.redefineOperator("f", "fill"));
        stringBuffer.append(this.redefineOperator("s", "stroke"));
        stringBuffer.append(this.redefineOperator("cp", "closepath"));
        stringBuffer.append(this.redefineOperator("rgb", "setrgbcolor"));
        stringBuffer.append(this.redefineOperator("sw", "setlinewidth"));
        stringBuffer.append(this.redefineOperator("sm", "setmiterlimit"));
        stringBuffer.append(this.redefineOperator("sj", "setlinejoin"));
        stringBuffer.append(this.redefineOperator("slc", "setlinecap"));
        stringBuffer.append(this.redefineOperator("sd", "setdash"));
        stringBuffer.append(-this.upperLeftCorner.x);
        stringBuffer.append(" ");
        stringBuffer.append(this.upperLeftCorner.y + (this.lowerRightCorner.y - this.upperLeftCorner.y));
        stringBuffer.append(" tr");
        stringBuffer.append(NEWLINE);
        stringBuffer.append(this.ps);
        return stringBuffer.toString();
    }

    public void psAppend(double d) {
        this.psAppend(this.df.format(d));
    }

    public void psAppend(String string) {
        char c;
        if (this.ps.length() > 0 && (c = this.ps.charAt(this.ps.length() - 1)) != ' ' && !String.valueOf(c).equals(NEWLINE)) {
            this.ps.append(' ');
        }
        this.ps.append(string);
    }

    public void psGSave() {
        this.psAppend("gs");
        this.psAppend(NEWLINE);
    }

    public void psGRestore() {
        this.psAppend("gr");
        this.psAppend(NEWLINE);
    }

    public void psMoveTo(double d, double d2) {
        this.psAppend(d);
        this.psAppend(d2);
        this.psAppend("m");
        this.psAppend(NEWLINE);
    }

    public void psLineTo(double d, double d2) {
        this.psAppend(d);
        this.psAppend(d2);
        this.psAppend("l");
        this.psAppend(NEWLINE);
    }

    public void psCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        this.psAppend(d);
        this.psAppend(d2);
        this.psAppend(d3);
        this.psAppend(d4);
        this.psAppend(d5);
        this.psAppend(d6);
        this.psAppend("c");
        this.psAppend(NEWLINE);
    }

    public void psTranslate(double d, double d2) {
        this.psAppend(d);
        this.psAppend(d2);
        this.psAppend("tr");
        this.psAppend(NEWLINE);
    }

    public void psScale(double d, double d2) {
        this.psAppend(d);
        this.psAppend(d2);
        this.psAppend("sc");
        this.psAppend(NEWLINE);
    }

    public void psFill() {
        this.psAppend("f");
        this.psAppend(NEWLINE);
    }

    public void psStroke() {
        this.psAppend("s");
        this.psAppend(NEWLINE);
    }

    public void psClosePath() {
        this.psAppend("cp");
        this.psAppend(NEWLINE);
    }

    public void psDrawShape(Shape shape, boolean bl) {
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        shape = this.transform.createTransformedShape(shape);
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.upperLeftCorner.x = (int)Math.min((double)this.upperLeftCorner.x, rectangle2D.getMinX());
        this.upperLeftCorner.y = (int)Math.min((double)this.upperLeftCorner.y, rectangle2D.getMinY());
        this.lowerRightCorner.x = (int)Math.max((double)this.lowerRightCorner.x, rectangle2D.getMaxX());
        this.lowerRightCorner.y = (int)Math.max((double)this.lowerRightCorner.y, rectangle2D.getMaxY());
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            double d3 = dArray[0];
            double d4 = -dArray[1];
            double d5 = dArray[2];
            double d6 = -dArray[3];
            double d7 = dArray[4];
            double d8 = -dArray[5];
            switch (n) {
                case 0: {
                    this.psMoveTo(d3, d4);
                    d = d3;
                    d2 = d4;
                    break;
                }
                case 1: {
                    this.psLineTo(d3, d4);
                    d = d3;
                    d2 = d4;
                    break;
                }
                case 3: {
                    this.psCurveTo(d3, d4, d5, d6, d7, d8);
                    d = d7;
                    d2 = d8;
                    break;
                }
                case 2: {
                    this.psCurveTo(d + 0.6666666666666666 * (d3 - d), d2 + 0.6666666666666666 * (d4 - d2), d3 + 0.3333333333333333 * (d5 - d3), d4 + 0.3333333333333333 * (d6 - d4), d5, d6);
                    d = d5;
                    d2 = d6;
                    break;
                }
                case 4: {
                    this.psClosePath();
                }
            }
            pathIterator.next();
        }
        if (bl) {
            this.psFill();
        } else {
            this.psStroke();
        }
    }

    public String arrayToString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray != null) {
            for (int i = 0; i < fArray.length; ++i) {
                stringBuffer.append(fArray[i]);
                if (i >= fArray.length - 1) continue;
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    public void draw(Shape shape) {
        this.psDrawShape(shape, false);
    }

    public void fill(Shape shape) {
        this.psDrawShape(shape, true);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        if (string == null || string.length() == 0) {
            return;
        }
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, this.getFont());
        this.drawString(attributedString.getIterator(), f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.fill(shape);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(byArray, 0, n, n2), n3, n4);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    public Graphics create() {
        return new XJGraphics2DPS();
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.transform(AffineTransform.getTranslateInstance(d, d2));
    }

    public void rotate(double d) {
        this.transform(AffineTransform.getRotateInstance(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform == null ? new AffineTransform() : affineTransform;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font == null ? Font.decode(null) : font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.psAppend((double)color.getRed() / 255.0);
        this.psAppend((double)color.getGreen() / 255.0);
        this.psAppend((double)color.getBlue() / 255.0);
        this.psAppend("rgb");
        this.psAppend(NEWLINE);
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            this.psAppend(basicStroke.getLineWidth() + " sw" + NEWLINE);
            this.psAppend(Math.max(1.0f, basicStroke.getMiterLimit()) + " sm" + NEWLINE);
            this.psAppend(basicStroke.getLineJoin() + " sj" + NEWLINE);
            this.psAppend(basicStroke.getEndCap() + " slc" + NEWLINE);
            this.psAppend("[" + this.arrayToString(basicStroke.getDashArray()) + "] " + basicStroke.getDashPhase() + " sd" + NEWLINE);
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        return graphics.getFontMetrics(font);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        Color color = this.getColor();
        this.setColor(this.background);
        this.fillRect(n, n2, n3, n4);
        this.setColor(color);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 2));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < n; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        this.draw(generalPath);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(null), image.getHeight(null), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, Color.white, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = n3 - n;
        int n10 = n4 - n2;
        BufferedImage bufferedImage = new BufferedImage(n9, n10, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n9, n10, n5, n6, n7, n8, color, imageObserver);
        this.psGSave();
        this.psTranslate(n, -(n2 + n10));
        this.psAppend("/picstr " + n9 * 3 + " string def" + NEWLINE);
        this.psScale(n9, n10);
        this.psAppend("/displayimage {" + NEWLINE);
        this.psAppend(n9 + " " + n10 + " " + 8 + " [" + n9 + " 0 0 -" + n10 + " 0 " + n10 + "]" + NEWLINE);
        this.psAppend("{currentfile picstr readhexstring pop} false 3 colorimage} def" + NEWLINE);
        this.psAppend("displayimage" + NEWLINE);
        boolean bl = true;
        try {
            this.getPixels(image, 0, 0, n9, n10);
        }
        catch (Exception exception) {
            System.err.println("XJGraphics2DPS: draw image error (" + exception + ")");
            bl = false;
        }
        this.psGRestore();
        return bl;
    }

    public void getPixels(Image image, int n, int n2, int n3, int n4) throws Exception {
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, 0, n3);
        pixelGrabber.grabPixels();
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new Exception("image fetch aborted or errored");
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.getSinglePixel(n + j, n2 + i, nArray[i * n3 + j]);
            }
            this.ps.append(NEWLINE);
        }
    }

    public void getSinglePixel(int n, int n2, int n3) {
        int n4 = n3 >> 16 & 0xFF;
        int n5 = n3 >> 8 & 0xFF;
        int n6 = n3 & 0xFF;
        char[] cArray = new char[2];
        XJGraphics2DPS.ASCIIHexEncode(n4, cArray);
        this.ps.append(cArray);
        XJGraphics2DPS.ASCIIHexEncode(n5, cArray);
        this.ps.append(cArray);
        XJGraphics2DPS.ASCIIHexEncode(n6, cArray);
        this.ps.append(cArray);
    }

    public static void ASCIIHexEncode(int n, char[] cArray) {
        cArray[0] = hexmap[n >> 4];
        cArray[1] = hexmap[n & 0xF];
    }

    public void dispose() {
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite composite) {
    }

    public void setPaint(Paint paint) {
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHints(Map map) {
    }

    public void addRenderingHints(Map map) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public Rectangle getClipBounds() {
        return null;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
    }

    public void setClip(int n, int n2, int n3, int n4) {
    }

    public Shape getClip() {
        return null;
    }

    public void setClip(Shape shape) {
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public Paint getPaint() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public void clip(Shape shape) {
    }
}

