/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.xjlib.appkit.frame.XJDialog;

public class XJColorChooser
extends XJDialog {
    JColorChooser cc;
    JPanel targetPanel;
    Color oldTargetColor = Color.black;

    public XJColorChooser(Container container, boolean bl) {
        this(container, bl, null);
    }

    public XJColorChooser(Container container, boolean bl, JPanel jPanel) {
        super(container, bl);
        this.setTitle("Choose a color");
        this.setSize(500, 400);
        if (jPanel != null) {
            this.targetPanel = jPanel;
            this.oldTargetColor = jPanel.getBackground();
        }
        this.cc = new JColorChooser(this.oldTargetColor);
        this.cc.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                XJColorChooser.this.updateTargetColor();
            }
        });
        this.getContentPane().add((Component)this.cc, "Center");
        JButton jButton = new JButton("Cancel");
        this.setCancelButton(jButton);
        JButton jButton2 = new JButton("OK");
        this.setOKButton(jButton2);
        this.setDefaultButton(jButton2);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(jButton2);
        box.add(Box.createHorizontalStrut(15));
        this.getContentPane().add((Component)box, "South");
    }

    protected void updateTargetColor() {
        this.updateTargetColor(this.cc.getColor());
    }

    protected void updateTargetColor(Color color) {
        if (this.targetPanel != null) {
            this.targetPanel.setBackground(color);
        }
    }

    public void dialogWillCloseCancel() {
        this.updateTargetColor(this.oldTargetColor);
    }

    public void dialogWillCloseOK() {
        this.updateTargetColor();
    }

    public Color getColor() {
        return this.cc.getColor();
    }
}

