/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;

public class XJMenuItem {
    protected JMenuItem jMenuItem = null;
    protected int tag = 0;
    protected Object object = null;
    protected XJMenuItemDelegate delegate = null;
    protected XJMenu parentMenu = null;

    public XJMenuItem() {
        this.init();
    }

    public XJMenuItem(String string, int n, int n2, XJMenuItemDelegate xJMenuItemDelegate) {
        this.init();
        this.setTag(n2);
        this.setTitle(string);
        this.setAccelerator(n);
        this.setDelegate(xJMenuItemDelegate);
    }

    public XJMenuItem(String string, Icon icon, int n, int n2, XJMenuItemDelegate xJMenuItemDelegate) {
        this.init();
        this.setTag(n2);
        this.setTitle(string);
        this.setIcon(icon);
        this.setAccelerator(n);
        this.setDelegate(xJMenuItemDelegate);
    }

    public XJMenuItem(String string, int n, int n2, int n3, XJMenuItemDelegate xJMenuItemDelegate) {
        this.init();
        this.setTag(n3);
        this.setTitle(string);
        this.setAccelerator(n, n2);
        this.setDelegate(xJMenuItemDelegate);
    }

    public XJMenuItem(String string, int n, XJMenuItemDelegate xJMenuItemDelegate) {
        this.init();
        this.setTag(n);
        this.setTitle(string);
        this.setDelegate(xJMenuItemDelegate);
    }

    public void init() {
        this.jMenuItem = new JMenuItem();
        this.jMenuItem.addActionListener(new MenuActionListener());
    }

    public void setMenu(XJMenu xJMenu) {
        this.parentMenu = xJMenu;
    }

    public void setDelegate(XJMenuItemDelegate xJMenuItemDelegate) {
        this.delegate = xJMenuItemDelegate;
    }

    public void setTag(int n) {
        this.tag = n;
    }

    public int getTag() {
        return this.tag;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setTitle(String string) {
        this.jMenuItem.setText(string);
    }

    public String getTitle() {
        return this.jMenuItem.getText();
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        if (bl && !bl2 || !bl && bl2) {
            this.jMenuItem.setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return this.jMenuItem.isEnabled();
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        if (bl && !bl2 || !bl && bl2) {
            this.jMenuItem.setSelected(bl);
        }
    }

    public boolean isSelected() {
        return this.jMenuItem.isSelected();
    }

    public void setAccelerator(int n) {
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
    }

    public void setAccelerator(int n, int n2) {
        this.jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
    }

    public void setIcon(Icon icon) {
        this.jMenuItem.setIcon(icon);
    }

    public JComponent getSwingComponent() {
        return this.jMenuItem;
    }

    public static int getKeyModifier() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public class MenuActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (XJMenuItem.this.delegate != null) {
                XJMenuItem.this.delegate.handleMenuEvent(XJMenuItem.this.parentMenu, XJMenuItem.this);
            }
        }
    }
}

