/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemSeparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJMenu
extends XJMenuItem {
    protected JMenu jMenu = new JMenu();
    protected List<XJMenuItem> items = new ArrayList<XJMenuItem>();
    protected XJMainMenuBar mainMenuBar;

    public XJMenu() {
        this.jMenu.addMenuListener(new XJMenuListener());
    }

    public void setMainMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.mainMenuBar = xJMainMenuBar;
        for (int i = 0; i < this.items.size(); ++i) {
            XJMenuItem xJMenuItem = this.items.get(i);
            if (!(xJMenuItem instanceof XJMenu)) continue;
            XJMenu xJMenu = (XJMenu)xJMenuItem;
            xJMenu.setMainMenuBar(xJMainMenuBar);
        }
    }

    @Override
    public void setTitle(String string) {
        this.jMenu.setText(string);
    }

    public void addSeparator() {
        this.items.add(new XJMenuItemSeparator());
        this.jMenu.addSeparator();
    }

    public void addItem(XJMenuItem xJMenuItem) {
        xJMenuItem.setMenu(this);
        this.items.add(xJMenuItem);
        this.jMenu.add(xJMenuItem.getSwingComponent());
    }

    public void addItem(XJMenu xJMenu) {
        xJMenu.setMenu(this);
        this.items.add(xJMenu);
        this.jMenu.add(xJMenu.getSwingComponent());
    }

    public void insertSeparatorBefore(int n) {
        XJMenuItem xJMenuItem = this.getItemForTag(n);
        if (xJMenuItem == null) {
            return;
        }
        this.insertSeparatorAtIndex(this.items.indexOf(xJMenuItem));
    }

    public void insertSeparatorAfter(int n) {
        XJMenuItem xJMenuItem = this.getItemForTag(n);
        if (xJMenuItem == null) {
            return;
        }
        this.insertSeparatorAtIndex(this.items.indexOf(xJMenuItem) + 1);
    }

    public void insertSeparatorAtIndex(int n) {
        this.items.add(n, new XJMenuItemSeparator());
        this.jMenu.insertSeparator(n);
    }

    public void insertItemBefore(XJMenuItem xJMenuItem, int n) {
        XJMenuItem xJMenuItem2 = this.getItemForTag(n);
        if (xJMenuItem2 == null) {
            return;
        }
        this.insertItemAtIndex(xJMenuItem, this.items.indexOf(xJMenuItem2));
    }

    public void insertItemAfter(XJMenuItem xJMenuItem, int n) {
        XJMenuItem xJMenuItem2 = this.getItemForTag(n);
        if (xJMenuItem2 == null) {
            return;
        }
        this.insertItemAtIndex(xJMenuItem, this.items.indexOf(xJMenuItem2) + 1);
    }

    public void insertItemAtIndex(XJMenuItem xJMenuItem, int n) {
        this.items.add(n, xJMenuItem);
        this.jMenu.add((Component)xJMenuItem.getSwingComponent(), n);
    }

    public void removeItem(int n) {
        this.jMenu.remove(n);
    }

    public XJMenuItem getItemForTag(int n) {
        for (XJMenuItem xJMenuItem : this.items) {
            if (xJMenuItem.getTag() != n) continue;
            return xJMenuItem;
        }
        return null;
    }

    public XJMenuItem getItemAtIndex(int n) {
        if (n >= 0 && n < this.items.size()) {
            return this.items.get(n);
        }
        return null;
    }

    public int getItemCount() {
        return this.jMenu.getItemCount();
    }

    public Iterator<XJMenuItem> itemIterator() {
        return this.items.iterator();
    }

    public void clear() {
        this.items.clear();
        this.jMenu.removeAll();
    }

    @Override
    public JComponent getSwingComponent() {
        return this.jMenu;
    }

    public class XJMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent menuEvent) {
            if (XJMenu.this.mainMenuBar != null) {
                XJMenu.this.mainMenuBar.menuSelected(XJMenu.this);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }
    }
}

