/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuBar;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarCustomizer;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemCheck;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJMainMenuBar
implements XJMenuItemDelegate {
    public static final int MI_NEW = 10000;
    public static final int MI_OPEN = 10001;
    public static final int MI_LOAD = 10002;
    public static final int MI_SAVE = 10003;
    public static final int MI_SAVEAS = 10004;
    public static final int MI_CLOSE = 10005;
    public static final int MI_QUIT = 10006;
    public static final int MI_HELP = 10020;
    public static final int MI_ABOUT = 10021;
    public static final int MI_PREFS = 10022;
    public static final int MI_UNDO = 10023;
    public static final int MI_REDO = 10024;
    public static final int MI_CUT = 10025;
    public static final int MI_COPY = 10026;
    public static final int MI_PASTE = 10027;
    public static final int MI_SELECT_ALL = 10028;
    public static final int MI_GC = 11000;
    public static final int MI_CLEAR_RECENT_FILES = 20000;
    public static final int MI_RECENT_FILES = 20001;
    public static final int MI_NO_WINDOW = 21000;
    public static final int MI_WINDOW = 21001;
    protected JMenuBar menuBar = null;
    protected XJMenu menuFile = null;
    protected XJMenu menuRecentFiles = null;
    protected XJMenu menuEdit = null;
    protected XJMenu menuWindow = null;
    protected XJMenu menuHelp = null;
    protected XJMenuItem menuItemUndo = null;
    protected XJMenuItem menuItemRedo = null;
    protected XJMenuBarCustomizer customizer = null;
    protected XJMenuBarDelegate delegate = null;
    protected List<XJMenu> customMenus = new ArrayList<XJMenu>();
    protected static List<XJMainMenuBar> mmbs = new ArrayList<XJMainMenuBar>();
    public static final int IGNORE_FILEMENU = 1;
    public static final int IGNORE_EDITMENU = 2;
    public static final int IGNORE_WINDOWMENU = 4;
    public static final int IGNORE_HELPMENU = 8;

    public static synchronized XJMainMenuBar createInstance() {
        XJMainMenuBar xJMainMenuBar = new XJMainMenuBar();
        mmbs.add(xJMainMenuBar);
        return xJMainMenuBar;
    }

    public static synchronized void removeInstance(XJMainMenuBar xJMainMenuBar) {
        mmbs.remove(xJMainMenuBar);
    }

    public static synchronized void refreshAllRecentFilesMenu() {
        for (XJMainMenuBar xJMainMenuBar : mmbs) {
            xJMainMenuBar.rebuildRecentFilesMenu();
        }
    }

    public static synchronized void refreshAllMenuBars() {
        for (XJMainMenuBar xJMainMenuBar : mmbs) {
            xJMainMenuBar.refresh();
        }
    }

    public static synchronized void setActiveWindowToAllMenuBar(XJWindow xJWindow) {
        for (XJMainMenuBar xJMainMenuBar : mmbs) {
            xJMainMenuBar.setActiveWindow(xJWindow);
        }
    }

    public static boolean isRecentFilesItem(XJMenuItem xJMenuItem) {
        return xJMenuItem.getTag() >= 20000 && xJMenuItem.getTag() < 21000;
    }

    public void setCustomizer(XJMenuBarCustomizer xJMenuBarCustomizer) {
        this.customizer = xJMenuBarCustomizer;
    }

    public void setDelegate(XJMenuBarDelegate xJMenuBarDelegate) {
        this.delegate = xJMenuBarDelegate;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public XJMenu getFileMenu() {
        return this.menuFile;
    }

    public void refresh() {
        this.refreshContent();
        this.refreshState();
    }

    public void refreshState() {
        this.refreshMenuState(this.menuFile);
        this.refreshMenuState(this.menuEdit);
        this.refreshMenuState(this.menuHelp);
        for (XJMenu xJMenu : this.customMenus) {
            this.refreshMenuState(xJMenu);
        }
    }

    public void refreshMenuEditState() {
        this.refreshMenuState(this.menuEdit);
    }

    public void refreshMenuState(XJMenu xJMenu) {
        if (xJMenu == null) {
            return;
        }
        for (int i = 0; i < xJMenu.getItemCount(); ++i) {
            XJMenuItem xJMenuItem = xJMenu.getItemAtIndex(i);
            if (xJMenuItem instanceof XJMenu) {
                this.refreshMenuState((XJMenu)xJMenuItem);
                continue;
            }
            this.refreshMenuItemState(xJMenuItem);
        }
    }

    public void refreshMenuItemState(XJMenuItem xJMenuItem) {
        if (this.delegate != null) {
            this.delegate.menuItemState(xJMenuItem);
        }
    }

    public void refreshContent() {
        this.rebuildRecentFilesMenu();
        this.rebuildWindowMenu();
    }

    public void menuUndoRedoItemState(XJUndo xJUndo) {
        if (xJUndo == null) {
            this.menuItemUndo.setEnabled(false);
            this.menuItemRedo.setEnabled(false);
        } else {
            this.menuItemUndo.setEnabled(xJUndo.canUndo());
            this.menuItemRedo.setEnabled(xJUndo.canRedo());
        }
    }

    public void setActiveWindow(XJWindow xJWindow) {
        XJMenuItem xJMenuItem;
        if (this.menuWindow == null) {
            return;
        }
        int n = XJApplication.shared().getWindows().indexOf(xJWindow);
        if (n >= 0 && (xJMenuItem = this.menuWindow.getItemAtIndex(n)) != null) {
            xJMenuItem.setSelected(true);
        }
    }

    public void setupMenuItem(XJMenuItem xJMenuItem, String string, int n, int n2, int n3) {
        xJMenuItem.setTitle(string);
        xJMenuItem.setTag(n3);
        if (n > 0 && n2 > 0) {
            xJMenuItem.setAccelerator(n, n2);
        } else if (n > 0) {
            xJMenuItem.setAccelerator(n);
        }
        xJMenuItem.setDelegate(this);
    }

    public XJMenuItem buildMenuItem(String string, int n, int n2, int n3) {
        XJMenuItem xJMenuItem = new XJMenuItem();
        this.setupMenuItem(xJMenuItem, string, n, n2, n3);
        return xJMenuItem;
    }

    public XJMenuItem buildMenuItem(String string, int n, int n2) {
        XJMenuItem xJMenuItem = new XJMenuItem();
        this.setupMenuItem(xJMenuItem, string, n, -1, n2);
        return xJMenuItem;
    }

    public XJMenuItemCheck buildMenuItemCheck(String string, int n, int n2) {
        XJMenuItemCheck xJMenuItemCheck = new XJMenuItemCheck();
        this.setupMenuItem(xJMenuItemCheck, string, n, -1, n2);
        return xJMenuItemCheck;
    }

    public XJMenuItem buildMenuItem(String string, int n) {
        return this.buildMenuItem(string, -1, n);
    }

    public void createMenuBar() {
        this.createMenuBar(0);
    }

    public void createMenuBar(int n) {
        this.customMenus.clear();
        this.menuBar = new JMenuBar();
        if ((n & 1) == 0) {
            this.addMenu(this.createFileMenu());
        }
        if ((n & 2) == 0) {
            this.addMenu(this.createEditMenu());
        }
        if (this.customizer != null) {
            this.customizer.customizeMenuBar(this);
        }
        if ((n & 4) == 0) {
            this.addMenu(this.createWindowMenu());
        }
        if ((n & 8) == 0) {
            this.addMenu(this.createHelpMenu());
        }
        if ("true".equals(System.getProperty("org.antlr.xjlib.debug.menu"))) {
            this.createDebugMenu();
        }
    }

    private void createDebugMenu() {
        XJMenu xJMenu = new XJMenu();
        xJMenu.setTitle("*");
        xJMenu.addItem(this.buildMenuItem("Garbage Collector", 11000));
        this.addMenu(xJMenu);
    }

    public XJMenu createFileMenu() {
        XJMenu xJMenu = this.buildFileMenu();
        if (this.customizer != null) {
            this.customizer.customizeFileMenu(xJMenu);
        }
        XJApplication.getAppDelegate().customizeFileMenu(xJMenu);
        return xJMenu;
    }

    public XJMenu createEditMenu() {
        XJMenu xJMenu = this.buildEditMenu();
        if (this.customizer != null) {
            this.customizer.customizeEditMenu(xJMenu);
        }
        XJApplication.getAppDelegate().customizeEditMenu(xJMenu);
        return xJMenu;
    }

    public XJMenu createWindowMenu() {
        XJMenu xJMenu = this.buildWindowMenu();
        if (this.customizer != null) {
            this.customizer.customizeWindowMenu(xJMenu);
        }
        XJApplication.getAppDelegate().customizeWindowMenu(xJMenu);
        return xJMenu;
    }

    public XJMenu createHelpMenu() {
        XJMenu xJMenu = this.buildHelpMenu();
        if (this.customizer != null) {
            this.customizer.customizeHelpMenu(xJMenu);
        }
        XJApplication.getAppDelegate().customizeHelpMenu(xJMenu);
        return xJMenu;
    }

    public void addCustomMenu(XJMenu xJMenu) {
        if (xJMenu == null) {
            return;
        }
        this.customMenus.add(xJMenu);
        this.addMenu(xJMenu);
    }

    private void addMenu(XJMenu xJMenu) {
        this.menuBar.add(xJMenu.getSwingComponent());
        xJMenu.setMainMenuBar(this);
    }

    private XJMenu buildFileMenu() {
        boolean bl = XJApplication.shared().supportsPersistence();
        this.menuFile = new XJMenu();
        this.menuFile.setTitle(XJLocalizable.getXJString("File"));
        this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("New"), 78, 10000));
        if (bl) {
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Open"), 79, 10001));
            this.menuFile.addItem(this.createRecentFilesMenu());
        }
        this.menuFile.addSeparator();
        this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Close"), 87, 10005));
        if (bl) {
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Save"), 83, 10003));
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("SaveAs"), 10004));
        }
        if (!XJSystem.isMacOS()) {
            this.menuFile.addSeparator();
            if (XJApplication.shared().hasPreferencesMenuItem()) {
                this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Preferences"), 44, 10022));
                this.menuFile.addSeparator();
            }
            this.menuFile.addItem(this.buildMenuItem(XJLocalizable.getXJString("Quit"), 81, 10006));
        }
        return this.menuFile;
    }

    public XJMenu createRecentFilesMenu() {
        this.menuRecentFiles = new XJMenu();
        this.rebuildRecentFilesMenu();
        return this.menuRecentFiles;
    }

    public void rebuildRecentFilesMenu() {
        if (this.menuRecentFiles == null) {
            return;
        }
        this.menuRecentFiles.clear();
        this.menuRecentFiles.setTitle(XJLocalizable.getXJString("OpenRecent"));
        int n = 0;
        for (Object e : XJApplication.shared().recentFiles()) {
            this.menuRecentFiles.addItem(this.buildMenuItem((String)e, 20001 + n++));
        }
        this.menuRecentFiles.addSeparator();
        this.menuRecentFiles.addItem(this.buildMenuItem(XJLocalizable.getXJString("ClearMenu"), 20000));
    }

    private XJMenu buildEditMenu() {
        this.menuEdit = new XJMenu();
        this.menuEdit.setTitle(XJLocalizable.getXJString("Edit"));
        this.menuItemUndo = this.buildMenuItem(XJLocalizable.getXJString("Undo"), 90, 10023);
        this.menuEdit.addItem(this.menuItemUndo);
        this.menuItemRedo = this.buildMenuItem(XJLocalizable.getXJString("Redo"), 90, XJMenuItem.getKeyModifier() | 1, 10024);
        this.menuEdit.addItem(this.menuItemRedo);
        this.menuEdit.addSeparator();
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Cut"), 88, 10025));
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Copy"), 67, 10026));
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("Paste"), 86, 10027));
        this.menuEdit.addSeparator();
        this.menuEdit.addItem(this.buildMenuItem(XJLocalizable.getXJString("SelectAll"), 65, 10028));
        return this.menuEdit;
    }

    private void buildWindowMenu_() {
        Object object;
        Iterator<XJWindow> iterator = XJApplication.shared().getWindows().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((XJWindow)object).shouldAppearsInWindowMenu()) continue;
            XJMenuItemCheck xJMenuItemCheck = this.buildMenuItemCheck(((XJFrame)object).getTitle(), n < 10 ? 48 + n : -1, 21001 + n);
            xJMenuItemCheck.setSelected(((XJFrame)object).isActive());
            this.menuWindow.addItem(xJMenuItemCheck);
            ++n;
        }
        if (n == 0) {
            object = new XJMenuItem(XJLocalizable.getXJString("NoWindows"), 21000, null);
            ((XJMenuItem)object).setEnabled(false);
            this.menuWindow.addItem((XJMenuItem)object);
        }
    }

    private XJMenu buildWindowMenu() {
        this.menuWindow = new XJMenu();
        this.menuWindow.setTitle(XJLocalizable.getXJString("Window"));
        this.buildWindowMenu_();
        return this.menuWindow;
    }

    private void rebuildWindowMenu() {
        if (this.menuWindow == null) {
            return;
        }
        for (int i = this.menuWindow.getItemCount() - 1; i >= 0; --i) {
            XJMenuItem xJMenuItem = this.menuWindow.getItemAtIndex(i);
            if (xJMenuItem == null || xJMenuItem.getTag() < 21000) continue;
            this.menuWindow.removeItem(i);
        }
        this.buildWindowMenu_();
    }

    private XJMenu buildHelpMenu() {
        this.menuHelp = new XJMenu();
        this.menuHelp.setTitle(XJLocalizable.getXJString("Help"));
        this.menuHelp.addItem(this.buildMenuItem(XJLocalizable.getXJString("Help"), 10020));
        if (!XJSystem.isMacOS()) {
            this.menuHelp.addSeparator();
            this.menuHelp.addItem(this.buildMenuItem(XJLocalizable.getXJString("About"), 10021));
        }
        return this.menuHelp;
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        XJDocument xJDocument = XJApplication.shared().getActiveDocument();
        switch (xJMenuItem.tag) {
            case 10000: {
                XJApplication.shared().newDocument();
                break;
            }
            case 10001: {
                XJApplication.shared().openDocument();
                break;
            }
            case 10002: {
                if (xJDocument == null || !xJDocument.performLoad()) break;
                xJDocument.changeReset();
                break;
            }
            case 10003: {
                if (xJDocument == null || !xJDocument.performSave(false)) break;
                xJDocument.changeReset();
                break;
            }
            case 10004: {
                if (xJDocument == null || !xJDocument.performSave(true)) break;
                xJDocument.changeReset();
                break;
            }
            case 20000: {
                XJApplication.shared().clearRecentFiles();
                break;
            }
            case 10006: {
                XJApplication.shared().performQuit();
                break;
            }
            case 10022: {
                XJApplication.shared().displayPrefs();
                break;
            }
            case 10021: {
                XJApplication.shared().displayAbout();
                break;
            }
            case 10020: {
                XJApplication.shared().displayHelp();
                break;
            }
            case 11000: {
                System.gc();
                break;
            }
            default: {
                if (xJMenuItem.tag >= 21001) {
                    XJWindow xJWindow = XJApplication.shared().getWindowsInWindowMenu().get(xJMenuItem.tag - 21001);
                    xJWindow.bringToFront();
                    xJMenuItem.setSelected(true);
                    break;
                }
                if (xJMenuItem.tag >= 20001 && xJMenuItem.tag <= 20011) {
                    if (XJApplication.shared().openDocument(xJMenuItem.getTitle())) break;
                    XJApplication.shared().removeRecentFile(xJMenuItem.getTitle());
                    break;
                }
                if (this.delegate == null) break;
                this.delegate.handleMenuEvent(xJMenu, xJMenuItem);
            }
        }
    }

    public void menuSelected(XJMenu xJMenu) {
        if (this.delegate != null) {
            this.delegate.handleMenuSelected(xJMenu);
        }
    }
}

