/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.io.IOException;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.utils.GDOTImporter;

public class GDOTImporterPlain
extends GDOTImporter {
    public static int factor = 80;

    public GElement parseLine(String string) throws IOException {
        String[] stringArray = this.parseTokens(string);
        if (stringArray[0].equals("graph")) {
            this.height = Float.parseFloat(stringArray[3]);
        } else {
            if (stringArray[0].equals("node")) {
                return this.createGraphNode(stringArray);
            }
            if (stringArray[0].equals("edge")) {
                return this.createGraphEdge(stringArray);
            }
        }
        return null;
    }

    public GElement createGraphNode(String[] stringArray) {
        float f = Float.parseFloat(stringArray[2]) * (float)factor;
        float f2 = (this.height - Float.parseFloat(stringArray[3])) * (float)factor;
        float f3 = Float.parseFloat(stringArray[4]) * (float)factor;
        float f4 = Float.parseFloat(stringArray[5]) * (float)factor;
        GDOTImporter.Node node = new GDOTImporter.Node();
        node.setDraggable(true);
        node.setPosition(f, f2);
        node.setSize(f3, f4);
        node.setRadius(f3 / 2.0f);
        node.setLabel(stringArray[6]);
        node.setDouble(stringArray[8].equals("doublecircle"));
        return node;
    }

    public GElement createGraphEdge(String[] stringArray) {
        int n;
        int n2 = (int)Float.parseFloat(stringArray[3]);
        Vector2D[] vector2DArray = new Vector2D[n2];
        for (n = 0; n < n2; ++n) {
            vector2DArray[n] = new Vector2D(Float.parseFloat(stringArray[4 + n * 2]) * (float)factor, (this.height - Float.parseFloat(stringArray[4 + n * 2 + 1])) * (float)factor);
        }
        n = 3 + 2 * n2 + 1;
        String string = null;
        Vector2D vector2D = null;
        if (this.isFloatString(stringArray[n + 1])) {
            string = stringArray[n];
            vector2D = new Vector2D(Float.parseFloat(stringArray[n + 1]) * (float)factor, (this.height - Float.parseFloat(stringArray[n + 2])) * (float)factor);
        }
        GElement gElement = this.graph.findElementWithLabel(stringArray[1]);
        GElement gElement2 = this.graph.findElementWithLabel(stringArray[2]);
        GLink gLink = new GLink(gElement, "CENTER", gElement2, "CENTER", 2, string, 0.0);
        gLink.setBezierControlPoints(vector2DArray);
        gLink.setBezierLabelPosition(vector2D);
        return gLink;
    }
}

