/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.utils.GDOTImporter;

public class GDOTImporterDOT
extends GDOTImporter {
    public static final int INCH_TO_PIXEL = 72;

    public GElement parseLine(String string) throws IOException {
        String[] stringArray = this.parseTokens(string);
        if (stringArray[0].equals("graph")) {
            this.parseGraphHeight(stringArray);
        } else {
            if (stringArray.length >= 2 && !stringArray[0].equals("node") && stringArray[1].equals("[")) {
                return this.createGraphNode(stringArray);
            }
            if (stringArray.length >= 3 && stringArray[1].equals("-") && stringArray[2].equals(">")) {
                return this.createGraphEdge(stringArray);
            }
        }
        return null;
    }

    public void parseGraphHeight(String[] stringArray) throws IOException {
        if (stringArray[2].equals("bb")) {
            String[] stringArray2 = this.parseTokens(stringArray[4]);
            this.height = Float.parseFloat(stringArray2[6]);
        }
    }

    public GElement createGraphNode(String[] stringArray) throws IOException {
        String[] stringArray2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[++n].equals("pos")) {
                stringArray2 = this.parseTokens(stringArray[n += 2]);
                f = Float.parseFloat(stringArray2[0]);
                f2 = this.height - Float.parseFloat(stringArray2[2]);
                continue;
            }
            if (stringArray[n].equals("width")) {
                f3 = Float.parseFloat(stringArray[n += 2]) * 72.0f;
                continue;
            }
            if (stringArray[n].equals("height")) {
                f4 = Float.parseFloat(stringArray[n += 2]) * 72.0f;
                continue;
            }
            if (!stringArray[n].equals("shape")) continue;
            bl = stringArray[n += 2].equals("doublecircle");
        }
        stringArray2 = new GDOTImporter.Node();
        stringArray2.setDraggable(true);
        stringArray2.setPosition(f, f2);
        stringArray2.setSize(f3, f4);
        stringArray2.setRadius(f3 / 2.0f);
        stringArray2.setLabel(stringArray[0]);
        stringArray2.setDouble(bl);
        return stringArray2;
    }

    public GElement createGraphEdge(String[] stringArray) throws IOException {
        String[] stringArray2;
        String string = stringArray[0];
        String string2 = stringArray[3];
        String string3 = null;
        Vector2D vector2D = null;
        Vector2D[] vector2DArray = null;
        int n = 4;
        while (n < stringArray.length - 1) {
            if (stringArray[++n].equals("label")) {
                string3 = stringArray[n += 2];
                continue;
            }
            if (stringArray[n].equals("lp")) {
                stringArray2 = this.parseTokens(stringArray[n += 2]);
                vector2D = new Vector2D(Float.parseFloat(stringArray2[0]), this.height - Float.parseFloat(stringArray2[2]));
                continue;
            }
            if (stringArray[n].equals("pos")) {
                vector2DArray = this.parseControlPoints(stringArray[n += 2]);
                continue;
            }
            if (!stringArray[n].equals(";")) continue;
        }
        stringArray2 = this.graph.findElementWithLabel(string);
        GElement gElement = this.graph.findElementWithLabel(string2);
        GLink gLink = new GLink((GElement)stringArray2, "CENTER", gElement, "CENTER", 2, string3, 0.0);
        if (vector2DArray == null) {
            System.err.println("No points for " + string + ", " + string2 + ", " + stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                System.out.println(string4);
            }
        }
        gLink.setBezierControlPoints(vector2DArray);
        gLink.setBezierLabelPosition(vector2D);
        return gLink;
    }

    public Vector2D[] parseControlPoints(String string) throws IOException {
        Object object;
        ArrayList<Vector2D> arrayList = new ArrayList<Vector2D>();
        Vector2D vector2D = null;
        String[] stringArray = this.parseTokens(string);
        int n = -1;
        while (n < stringArray.length - 1) {
            String string2;
            if (stringArray[++n].equals("e")) {
                object = stringArray[n += 2];
                string2 = stringArray[n += 2];
                vector2D = new Vector2D(Float.parseFloat((String)object), this.height - Float.parseFloat(string2));
                continue;
            }
            if (!this.isFloatString(stringArray[n]) || !this.isFloatString(stringArray[n + 2])) continue;
            object = stringArray[n];
            string2 = stringArray[n += 2];
            arrayList.add(new Vector2D(Float.parseFloat((String)object), this.height - Float.parseFloat(string2)));
        }
        if (vector2D != null) {
            arrayList.add(vector2D);
        }
        object = new Vector2D[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Vector2D)arrayList.get(i);
        }
        return object;
    }
}

