/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.utils;

import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GElementCircle;

public abstract class GDOTImporter {
    protected GElement graph;
    protected float height = 0.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GElement generateGraph(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            int n;
            this.graph = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = -1;
            while ((n = bufferedReader.read()) != -1) {
                if (n == 10) {
                    if (n2 == 92) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    } else {
                        GElement gElement = this.parseLine(stringBuffer.toString());
                        if (gElement != null) {
                            if (this.graph == null) {
                                this.graph = gElement;
                            } else {
                                this.graph.addElement(gElement);
                            }
                        }
                        stringBuffer.delete(0, stringBuffer.length());
                    }
                } else if (n != 13) {
                    stringBuffer.append((char)n);
                }
                n2 = n;
            }
        }
        finally {
            bufferedReader.close();
        }
        return this.graph;
    }

    public String[] parseTokens(String string) throws IOException {
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.parseNumbers();
        streamTokenizer.wordChars(95, 95);
        int n = streamTokenizer.nextToken();
        while (n != -1) {
            stringArray = null;
            switch (n) {
                case -2: {
                    stringArray = String.valueOf(streamTokenizer.nval);
                    break;
                }
                case -3: {
                    stringArray = streamTokenizer.sval;
                    break;
                }
                case 34: 
                case 39: {
                    stringArray = streamTokenizer.sval;
                    break;
                }
                case 10: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    stringArray = String.valueOf((char)streamTokenizer.ttype);
                }
            }
            if (stringArray != null) {
                arrayList.add(stringArray);
            }
            n = streamTokenizer.nextToken();
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public abstract GElement parseLine(String var1) throws IOException;

    public abstract GElement createGraphNode(String[] var1) throws IOException;

    public abstract GElement createGraphEdge(String[] var1) throws IOException;

    public boolean isFloatString(String string) {
        try {
            Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static class StringTokenizer {
        public String s;
        public int position;

        public StringTokenizer(String string) {
            this.s = string;
            this.position = -1;
        }

        public String nextToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.skipChar((char)this.getChar(1))) {
                this.nextChar();
            }
            while (this.nextChar()) {
                char c = this.getChar();
                if (c == '\"') {
                    stringBuffer.append(this.parseString());
                    break;
                }
                if (this.isWordChar(c)) {
                    stringBuffer.append(c);
                    continue;
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(c);
                    break;
                }
                --this.position;
                break;
            }
            if (stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }

        public String parseString() {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (this.nextChar()) {
                char c = this.getChar();
                if (c == '\\' && !bl) {
                    bl = true;
                    continue;
                }
                if (c == '\"' && !bl) break;
                stringBuffer.append(c);
                bl = false;
            }
            return stringBuffer.toString();
        }

        public boolean nextChar() {
            ++this.position;
            return this.position < this.s.length();
        }

        public char getChar() {
            return (char)this.getChar(0);
        }

        public int getChar(int n) {
            int n2 = this.position + n;
            if (n2 < this.s.length()) {
                return this.s.charAt(n2);
            }
            return -1;
        }

        public boolean isWordChar(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '.';
        }

        public boolean skipChar(char c) {
            return c == ' ' || c == '\t';
        }
    }

    public static class Node
    extends GElementCircle {
        public boolean doublecircle;
        public float width;
        public float height;

        public void setDouble(boolean bl) {
            this.doublecircle = bl;
        }

        public void setSize(float f, float f2) {
            this.width = f;
            this.height = f2;
        }

        public void drawShape(Graphics2D graphics2D) {
            int n = (int)(this.getPositionX() - (double)(this.width / 2.0f));
            int n2 = (int)(this.getPositionY() - (double)(this.height / 2.0f));
            graphics2D.drawOval(n, n2, (int)this.width, (int)this.height);
            if (this.doublecircle) {
                n = (int)(this.getPositionX() - (double)(this.width / 2.0f));
                n2 = (int)(this.getPositionY() - (double)(this.height / 2.0f));
                graphics2D.drawOval(n + 3, n2 + 3, (int)(this.width - 6.0f), (int)(this.height - 6.0f));
            }
        }
    }
}

