/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.timer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.timer.GTimerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTimer {
    protected List<GElement> elements = new ArrayList<GElement>();
    protected Timer timer = null;
    protected GTimerDelegate delegate = null;
    protected int delay = 50;

    public GTimer(GTimerDelegate gTimerDelegate) {
        this.delegate = gTimerDelegate;
    }

    public GTimer(GTimerDelegate gTimerDelegate, int n) {
        this.delegate = gTimerDelegate;
        this.delay = n;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void refresh() {
        if (this.elements.isEmpty()) {
            this.stop();
        } else {
            this.start();
        }
    }

    public void start() {
        if (this.timer == null) {
            this.timer = new Timer(this.delay, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GTimer.this.delegate.timerFired(GTimer.this);
                }
            });
            this.timer.start();
        } else if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public synchronized void add(GElement gElement) {
        if (this.elements.contains(gElement)) {
            return;
        }
        this.elements.add(gElement);
        this.refresh();
    }

    public synchronized void remove(GElement gElement) {
        this.elements.remove(gElement);
        this.refresh();
    }

    public synchronized void clear() {
        this.elements.clear();
        this.refresh();
    }

    public synchronized boolean contains(GElement gElement) {
        return this.elements.contains(gElement);
    }

    public List<GElement> getElements() {
        return this.elements;
    }
}

