/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Graphics;
import java.awt.Graphics2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class SLinkBezier
extends SLinkArc
implements XJXMLSerializable {
    protected Vector2D[] controlPointsAbs;
    protected Vector2D labelPositionAbs;
    protected Vector2D[] controlPointsRel;
    protected Vector2D labelPositionRel;
    protected Vector2D oldStart;
    protected Vector2D oldEnd;
    protected Vector2D originalEndPointOffset;
    protected double originalZLength;
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    protected double x1 = 0.0;
    protected double y1 = 0.0;
    protected static final int MODE_END = 1;
    protected static final int MODE_NOSTRETCH = 0;
    protected static final int MODE_STRETCH = -1;

    public void setControlPoints(Vector2D[] vector2DArray) {
        this.controlPointsAbs = vector2DArray;
        this.resetFrame();
        for (int i = 0; i < vector2DArray.length; ++i) {
            this.updateFrame(vector2DArray[i]);
        }
    }

    public void setLabelPosition(Vector2D vector2D) {
        this.labelPositionAbs = vector2D;
    }

    public Rect getFrame() {
        return new Rect(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
    }

    public boolean contains(double d, double d2) {
        return false;
    }

    public Vector2D absToRel(Vector2D vector2D) {
        if (this.selfLoop) {
            return vector2D.sub(this.start);
        }
        Vector2D vector2D2 = this.end.sub(this.start);
        Vector2D vector2D3 = vector2D.sub(this.start);
        double d = vector2D3.dot(vector2D2) / vector2D2.length();
        Vector2D vector2D4 = vector2D2.normalize().setLength(d);
        Vector2D vector2D5 = vector2D3.sub(vector2D4);
        double d2 = vector2D5.length() * (double)vector2D3.crossSign(vector2D2);
        return new Vector2D(d, d2);
    }

    public Vector2D relToAbs(Vector2D vector2D, int n) {
        if (this.selfLoop) {
            return this.start.add(vector2D);
        }
        Vector2D vector2D2 = this.end.sub(this.start);
        double d = vector2D2.length() / this.originalZLength;
        double d2 = vector2D.getX();
        double d3 = vector2D.getY();
        if (n == 1) {
            return this.end.add(this.originalEndPointOffset);
        }
        if (n == 0) {
            d = 1.0;
        }
        Vector2D vector2D3 = vector2D2.normalize().setLength(d * d2);
        Vector2D vector2D4 = vector2D2.copy().rotate(-90.0).normalize().setLength(d3);
        return this.start.add(vector2D3.add(vector2D4));
    }

    public void update() {
        int n = this.controlPointsAbs.length;
        if (this.controlPointsRel == null) {
            this.controlPointsRel = new Vector2D[this.controlPointsAbs.length];
            for (int i = 0; i < n; ++i) {
                this.controlPointsRel[i] = this.absToRel(this.controlPointsAbs[i]);
            }
            if (this.labelPositionAbs != null) {
                this.labelPositionRel = this.absToRel(this.labelPositionAbs);
            }
            this.originalEndPointOffset = this.controlPointsAbs[n - 1].sub(this.end);
            this.originalZLength = this.end.sub(this.start).length();
        } else if (!this.oldStart.equals(this.start) || !this.oldEnd.equals(this.end)) {
            this.resetFrame();
            for (int i = 0; i < n; ++i) {
                this.controlPointsAbs[i] = this.relToAbs(this.controlPointsRel[i], i == 0 ? 0 : (i == n - 1 ? 1 : -1));
                this.updateFrame(this.controlPointsAbs[i]);
            }
            if (this.labelPositionRel != null) {
                this.labelPositionAbs = this.relToAbs(this.labelPositionRel, -1);
            }
        }
        this.oldStart = this.start;
        this.oldEnd = this.end;
    }

    public void draw(Graphics2D graphics2D) {
        this.drawShape(graphics2D);
    }

    public void drawShape(Graphics2D graphics2D) {
        if (this.controlPointsAbs != null) {
            this.bspline(graphics2D);
        }
        if (this.labelPositionAbs != null) {
            this.label.setPosition(this.labelPositionAbs.getX(), this.labelPositionAbs.getY());
            this.label.draw(graphics2D);
        }
    }

    public void lines(Graphics graphics) {
        graphics.setColor(this.color);
        for (int i = 0; i < this.controlPointsAbs.length; ++i) {
            Vector2D vector2D = this.controlPointsAbs[i];
            double d = vector2D.x;
            double d2 = vector2D.y;
            graphics.fillRect((int)(d - 2.0), (int)(d2 - 2.0), 4, 4);
        }
    }

    public void bspline(Graphics graphics) {
        Vector2D vector2D;
        graphics.setColor(this.color);
        int n = this.controlPointsAbs.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.1;
        boolean bl = true;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 1; i < n - 2; ++i) {
            vector2D = this.controlPointsAbs[i - 1];
            Vector2D vector2D2 = this.controlPointsAbs[i];
            Vector2D vector2D3 = this.controlPointsAbs[i + 1];
            Vector2D vector2D4 = this.controlPointsAbs[i + 2];
            double d6 = vector2D.x;
            double d7 = vector2D2.x;
            double d8 = vector2D3.x;
            double d9 = vector2D4.x;
            double d10 = vector2D.y;
            double d11 = vector2D2.y;
            double d12 = vector2D3.y;
            double d13 = vector2D4.y;
            double d14 = (-d6 + 3.0 * (d7 - d8) + d9) / 6.0;
            double d15 = (-d10 + 3.0 * (d11 - d12) + d13) / 6.0;
            double d16 = (d6 - 2.0 * d7 + d8) / 2.0;
            double d17 = (d10 - 2.0 * d11 + d12) / 2.0;
            double d18 = (d8 - d6) / 2.0;
            double d19 = (d12 - d10) / 2.0;
            double d20 = (d6 + 4.0 * d7 + d8) / 6.0;
            double d21 = (d10 + 4.0 * d11 + d12) / 6.0;
            for (double d22 = 0.0; d22 <= 1.0; d22 += d3) {
                double d23 = d;
                double d24 = d2;
                double d25 = ((d14 * d22 + d16) * d22 + d18) * d22 + d20;
                double d26 = ((d15 * d22 + d17) * d22 + d19) * d22 + d21;
                d = (int)Math.round(d25);
                d2 = (int)Math.round(d26);
                if (bl) {
                    bl = false;
                    d4 = d;
                    d5 = d2;
                    continue;
                }
                graphics.drawLine((int)d23, (int)d24, (int)d, (int)d2);
            }
        }
        Vector2D vector2D5 = this.controlPointsAbs[0];
        graphics.drawLine((int)vector2D5.getX(), (int)vector2D5.getY(), (int)d4, (int)d5);
        vector2D = this.controlPointsAbs[n - 1];
        graphics.drawLine((int)d, (int)d2, (int)vector2D.getX(), (int)vector2D.getY());
        this.arrow.setAnchor(vector2D.getX(), vector2D.getY());
        this.arrow.setDirection(new Vector2D(d - vector2D.getX(), d2 - vector2D.getY()));
        this.arrow.draw(graphics);
    }

    private void resetFrame() {
        if (this.start != null && this.end != null) {
            this.x0 = Math.min(this.start.x, this.end.x);
            this.y0 = Math.min(this.start.y, this.end.y);
            this.x1 = Math.max(this.start.x, this.end.x);
            this.y1 = Math.max(this.start.y, this.end.y);
        } else {
            this.x0 = 2.147483647E9;
            this.y0 = 2.147483647E9;
            this.x1 = -2.147483648E9;
            this.y1 = -2.147483648E9;
        }
    }

    private void updateFrame(Vector2D vector2D) {
        this.updateFrame(vector2D.x, vector2D.y);
    }

    private void updateFrame(double d, double d2) {
        this.x0 = Math.min(this.x0, d);
        this.y0 = Math.min(this.y0, d2);
        this.x1 = Math.max(this.x1, d);
        this.y1 = Math.max(this.y1, d2);
    }
}

