/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class SLinkArc
extends SLink
implements XJXMLSerializable {
    protected transient QuadCurve2D.Double quad;
    protected transient CubicCurve2D.Double cubic;
    protected transient Shape shape;
    Vector2D vlabel;
    Vector2D pmiddle;

    public void setMouse(Point point) {
        this.setMouse(Vector2D.vector(point));
    }

    public void setMouse(Vector2D vector2D) {
        this.setDirection(vector2D.sub(this.end));
    }

    public void setFlatenessByMouse(Vector2D vector2D) {
        Vector2D vector2D2 = this.getEndWithOffset().sub(this.getStartWithOffset());
        double d = vector2D.sub(this.getStartWithOffset()).dot(vector2D2.normalize());
        vector2D2.setLength(d);
        Vector2D vector2D3 = this.getStartWithOffset().add(vector2D2);
        Vector2D vector2D4 = vector2D.sub(vector2D3);
        double d2 = vector2D2.cross(vector2D4);
        if (d2 == 0.0) {
            this.setFlateness(0.0);
        } else {
            this.setFlateness(-2.0 * vector2D4.length() * d2 / Math.abs(d2));
        }
    }

    public void setMousePosition(Vector2D vector2D) {
        this.setFlatenessByMouse(vector2D);
    }

    public boolean contains(PathIterator pathIterator, double d, double d2) {
        double[] dArray = new double[6];
        double d3 = -1.0;
        double d4 = -1.0;
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(pathIterator, 0.8);
        while (!flatteningPathIterator.isDone()) {
            switch (flatteningPathIterator.currentSegment(dArray)) {
                case 0: {
                    d3 = dArray[0];
                    d4 = dArray[1];
                    break;
                }
                case 1: {
                    double d5 = dArray[0];
                    double d6 = dArray[1];
                    double d7 = Math.min(d3, d5);
                    double d8 = Math.min(d4, d6);
                    double d9 = Math.max(d3, d5);
                    double d10 = Math.max(d4, d6);
                    if (Math.abs(d7 - d9) < 4.0 || Math.abs(d8 - d10) < 4.0) {
                        d7 -= 4.0;
                        d8 -= 4.0;
                        d9 += 4.0;
                        d10 += 4.0;
                    }
                    if (d >= d7 && d <= d9 && d2 >= d8 && d2 <= d10) {
                        return true;
                    }
                    d3 = d5;
                    d4 = d6;
                }
            }
            flatteningPathIterator.next();
        }
        return false;
    }

    public boolean contains(double d, double d2) {
        if (this.selfLoop && this.cubic != null) {
            return this.contains(this.cubic.getPathIterator(null), d, d2);
        }
        if (!this.selfLoop && this.quad != null) {
            return this.contains(this.quad.getPathIterator(null), d, d2);
        }
        return false;
    }

    public void update() {
        if (this.selfLoop) {
            if (this.cubic == null) {
                this.cubic = new CubicCurve2D.Double();
            }
            Vector2D vector2D = this.direction.copy();
            vector2D.stretch(1.7);
            if (vector2D.length() < 100.0) {
                vector2D.setLength(100.0);
            }
            vector2D.rotate(-40.0);
            this.cubic.ctrlx1 = this.getStartWithOffset().getX() + vector2D.getX();
            this.cubic.ctrly1 = this.getStartWithOffset().getY() + vector2D.getY();
            vector2D.rotate(80.0);
            this.cubic.ctrlx2 = this.getStartWithOffset().getX() + vector2D.getX();
            this.cubic.ctrly2 = this.getStartWithOffset().getY() + vector2D.getY();
            Vector2D vector2D2 = new Vector2D(this.cubic.ctrlx1, this.cubic.ctrly1).sub(this.getStartWithOffset());
            Vector2D vector2D3 = new Vector2D(this.cubic.ctrlx2, this.cubic.ctrly2).sub(this.getStartWithOffset());
            vector2D2 = vector2D2.normalize();
            vector2D2.stretch(this.startTangentOffset);
            vector2D3 = vector2D3.normalize();
            vector2D3.stretch(this.endTangentOffset);
            this.cubic.x1 = this.getStartWithOffset().getX() + vector2D2.getX();
            this.cubic.y1 = this.getStartWithOffset().getY() + vector2D2.getY();
            this.cubic.x2 = this.getEndWithOffset().getX() + vector2D3.getX();
            this.cubic.y2 = this.getEndWithOffset().getY() + vector2D3.getY();
            Vector2D vector2D4 = this.direction.copy();
            vector2D4.setLength(vector2D4.length() + 15.0);
            if (vector2D4.length() < 75.0) {
                vector2D4.setLength(75.0);
            }
            Vector2D vector2D5 = this.getStartWithOffset().add(vector2D4);
            this.label.setPosition(vector2D5);
            this.arrow.setAnchor(this.cubic.x2, this.cubic.y2);
            this.arrow.setDirection(new Vector2D(this.cubic.ctrlx2 - this.cubic.x2, this.cubic.ctrly2 - this.cubic.y2));
            this.shape = this.cubic;
        } else {
            Vector2D vector2D = this.getEndWithOffset().sub(this.getStartWithOffset());
            vector2D.stretch(0.5);
            Vector2D vector2D6 = vector2D.normalize();
            vector2D6.rotate(-90.0);
            if (this.flateness == 0.0) {
                vector2D6.setLength(0.01);
            } else {
                vector2D6.setLength(this.flateness);
            }
            Vector2D vector2D7 = vector2D.add(vector2D6);
            if (this.quad == null) {
                this.quad = new QuadCurve2D.Double();
            }
            this.quad.x1 = this.getStartWithOffset().getX();
            this.quad.y1 = this.getStartWithOffset().getY();
            this.quad.x2 = this.getEndWithOffset().getX();
            this.quad.y2 = this.getEndWithOffset().getY();
            this.quad.ctrlx = this.getStartWithOffset().getX() + vector2D7.getX();
            this.quad.ctrly = this.getStartWithOffset().getY() + vector2D7.getY();
            Vector2D vector2D8 = new Vector2D(this.quad.ctrlx, this.quad.ctrly);
            Vector2D vector2D9 = vector2D8.sub(this.getStartWithOffset());
            Vector2D vector2D10 = vector2D8.sub(this.getEndWithOffset());
            vector2D9 = vector2D9.normalize();
            vector2D9.stretch(this.startTangentOffset);
            vector2D10 = vector2D10.normalize();
            vector2D10.stretch(this.endTangentOffset);
            this.quad.x1 = this.getStartWithOffset().getX() + vector2D9.getX();
            this.quad.y1 = this.getStartWithOffset().getY() + vector2D9.getY();
            this.quad.x2 = this.getEndWithOffset().getX() + vector2D10.getX();
            this.quad.y2 = this.getEndWithOffset().getY() + vector2D10.getY();
            this.pmiddle = new Vector2D(this.quad.x1 + (this.quad.x2 - this.quad.x1) * 0.5, this.quad.y1 + (this.quad.y2 - this.quad.y1) * 0.5);
            this.vlabel = new Vector2D(this.quad.x2 - this.quad.x1, this.quad.y2 - this.quad.y1).rotate(90 * (this.flateness < 0.0 ? 1 : -1));
            this.vlabel.setLength(Math.abs(this.flateness) * 0.5 + 20.0);
            this.label.setPosition(this.pmiddle.add(this.vlabel));
            this.arrow.setAnchor(this.quad.x2, this.quad.y2);
            this.arrow.setDirection(vector2D8.sub(this.getEndWithOffset()));
            this.shape = this.quad;
        }
    }

    public void draw(Graphics2D graphics2D) {
        if (this.shape == null || this.arrow == null || this.label == null) {
            return;
        }
        graphics2D.setColor(this.color);
        this.drawShape(graphics2D);
        this.label.draw(graphics2D);
    }

    public void drawShape(Graphics2D graphics2D) {
        if (this.shape == null || this.arrow == null || this.label == null) {
            return;
        }
        graphics2D.draw(this.shape);
        if (this.arrowVisible) {
            this.arrow.draw(graphics2D);
        }
    }
}

