/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.shape;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.shape.SArrow;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public abstract class SLink
implements XJXMLSerializable {
    protected Vector2D start;
    protected Vector2D end;
    protected Vector2D startDirection;
    protected Vector2D endDirection;
    protected Vector2D startOffset;
    protected Vector2D endOffset;
    protected double startTangentOffset;
    protected double endTangentOffset;
    protected Vector2D direction;
    protected double flateness;
    protected SArrow arrow = new SArrow();
    protected SLabel label = new SLabel();
    protected boolean selfLoop = false;
    protected boolean arrowVisible = true;
    protected Color color = Color.black;
    protected transient Vector2D startWithOffset = null;
    protected transient Vector2D endWithOffset = null;

    public void setStartAnchor(Anchor2D anchor2D) {
        this.setStart(anchor2D.position);
        this.setStartDirection(anchor2D.direction);
    }

    public void setEndAnchor(Anchor2D anchor2D) {
        this.setEnd(anchor2D.position);
        this.setEndDirection(anchor2D.direction);
    }

    public void setStart(Vector2D vector2D) {
        this.start = vector2D.copy();
        this.computeOffsets();
    }

    public void setStart(double d, double d2) {
        this.setStart(new Vector2D(d, d2));
    }

    public Vector2D getStart() {
        return this.start;
    }

    public void setEnd(Vector2D vector2D) {
        this.end = vector2D.copy();
        this.computeOffsets();
    }

    public void setEnd(double d, double d2) {
        this.setEnd(new Vector2D(d, d2));
    }

    public void setEnd(Point point) {
        this.end = Vector2D.vector(point);
    }

    public Vector2D getEnd() {
        return this.end;
    }

    public void setDirection(Vector2D vector2D) {
        this.direction = vector2D;
    }

    public Vector2D getDirection() {
        return this.direction;
    }

    public void setFlateness(double d) {
        this.flateness = d;
    }

    public double getFlateness() {
        return this.flateness;
    }

    public void setStartDirection(Vector2D vector2D) {
        this.startDirection = vector2D;
    }

    public Vector2D getStartDirection() {
        return this.startDirection;
    }

    public void setEndDirection(Vector2D vector2D) {
        this.endDirection = vector2D;
    }

    public Vector2D getEndDirection() {
        return this.endDirection;
    }

    public void setStartTangentOffset(double d) {
        this.startTangentOffset = d;
    }

    public double getStartTangentOffset() {
        return this.startTangentOffset;
    }

    public void setEndTangentOffset(double d) {
        this.endTangentOffset = d;
    }

    public double getEndTangentOffset() {
        return this.endTangentOffset;
    }

    public void setStartOffset(Vector2D vector2D) {
        this.startOffset = vector2D;
        this.computeOffsets();
    }

    public Vector2D getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(Vector2D vector2D) {
        this.endOffset = vector2D;
        this.computeOffsets();
    }

    public Vector2D getEndOffset() {
        return this.endOffset;
    }

    public void computeOffsets() {
        this.startWithOffset = this.start;
        this.endWithOffset = this.end;
        if (this.start != null && this.startOffset != null) {
            this.startWithOffset = this.start.add(this.startOffset);
        }
        if (this.end != null && this.endOffset != null) {
            this.endWithOffset = this.end.add(this.endOffset);
        }
    }

    public Vector2D getStartWithOffset() {
        return this.startWithOffset;
    }

    public Vector2D getEndWithOffset() {
        return this.endWithOffset;
    }

    public void setArrow(SArrow sArrow) {
        this.arrow = sArrow;
    }

    public SArrow getArrow() {
        return this.arrow;
    }

    public void setArrowVisible(boolean bl) {
        this.arrowVisible = bl;
    }

    public void setLabel(String string) {
        this.label.setTitle(string);
    }

    public void setLabel(SLabel sLabel) {
        this.label = sLabel;
    }

    public SLabel getLabel() {
        return this.label;
    }

    public void setSelfLoop(boolean bl) {
        this.selfLoop = bl;
    }

    public boolean isSelfLoop() {
        return this.selfLoop;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setLabelColor(Color color) {
        this.label.setColor(color);
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(bl);
    }

    public boolean isLabelVisible() {
        return this.label.isVisible();
    }

    public Rect getFrame() {
        return new Rect(this.start, this.end);
    }

    public void setMousePosition(Vector2D vector2D) {
    }

    public abstract boolean contains(double var1, double var3);

    public abstract void update();

    public abstract void draw(Graphics2D var1);

    public abstract void drawShape(Graphics2D var1);
}

