/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.appkit.gview.shape.SLinkBezier;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GLink
extends GElement
implements XJXMLSerializable {
    public static final int SHAPE_ARC = 0;
    public static final int SHAPE_ELBOW = 1;
    public static final int SHAPE_BEZIER = 2;
    public GElement source = null;
    public GElement target = null;
    public String sourceAnchorKey = null;
    public String targetAnchorKey = null;
    public String pattern = null;
    protected SLink link = null;
    protected int shape = 0;

    public GLink() {
    }

    public GLink(GElement gElement, String string, GElement gElement2, String string2, int n, String string3, Point point, double d) {
        this.source = gElement;
        this.target = gElement2;
        this.sourceAnchorKey = string;
        this.targetAnchorKey = string2;
        this.shape = n;
        this.pattern = string3;
        this.initializeLink(d);
        this.setSourceTangentOffset(gElement.getDefaultAnchorOffset(string));
        this.setTargetTangentOffset(gElement2.getDefaultAnchorOffset(string2));
        this.link.setDirection(Vector2D.vector(point).sub(gElement2.getPosition()));
    }

    public GLink(GElement gElement, String string, GElement gElement2, String string2, int n, String string3, double d) {
        this.source = gElement;
        this.target = gElement2;
        this.sourceAnchorKey = string;
        this.targetAnchorKey = string2;
        this.shape = n;
        this.pattern = string3;
        this.initializeLink(d);
        if (gElement == gElement2) {
            this.link.setDirection(new Vector2D(0.0, 1.0));
        } else {
            this.link.setDirection(gElement.getPosition().sub(gElement2.getPosition()));
        }
        this.setSourceTangentOffset(gElement.getDefaultAnchorOffset(string));
        this.setTargetTangentOffset(gElement2.getDefaultAnchorOffset(string2));
    }

    public void setBezierControlPoints(Vector2D[] vector2DArray) {
        if (this.link instanceof SLinkBezier) {
            SLinkBezier sLinkBezier = (SLinkBezier)this.link;
            sLinkBezier.setControlPoints(vector2DArray);
        }
    }

    public void setBezierLabelPosition(Vector2D vector2D) {
        if (this.link instanceof SLinkBezier) {
            SLinkBezier sLinkBezier = (SLinkBezier)this.link;
            sLinkBezier.setLabelPosition(vector2D);
        }
    }

    protected SLink createLinkInstance() {
        switch (this.shape) {
            case 0: {
                return new SLinkArc();
            }
            case 1: {
                return new SLinkElbow();
            }
            case 2: {
                return new SLinkBezier();
            }
        }
        return null;
    }

    protected void initializeLink(double d) {
        if (this.link == null) {
            this.link = this.createLinkInstance();
            this.link.setFlateness(d);
        }
    }

    public void setSource(GElement gElement) {
        this.source = gElement;
    }

    public GElement getSource() {
        return this.source;
    }

    public void setTarget(GElement gElement) {
        this.target = gElement;
    }

    public GElement getTarget() {
        return this.target;
    }

    public void setSourceAnchorKey(String string) {
        this.sourceAnchorKey = string;
    }

    public String getSourceAnchorKey() {
        return this.sourceAnchorKey;
    }

    public void setTargetAnchorKey(String string) {
        this.targetAnchorKey = string;
    }

    public String getTargetAnchorKey() {
        return this.targetAnchorKey;
    }

    public void setSourceTangentOffset(double d) {
        this.link.setStartTangentOffset(d);
    }

    public void setTargetTangentOffset(double d) {
        this.link.setEndTangentOffset(d);
    }

    public void setSourceOffset(double d, double d2) {
        this.setSourceOffset(new Vector2D(d, d2));
    }

    public void setSourceOffset(Vector2D vector2D) {
        this.link.setStartOffset(vector2D);
    }

    public void setTargetOffset(double d, double d2) {
        this.setTargetOffset(new Vector2D(d, d2));
    }

    public void setTargetOffset(Vector2D vector2D) {
        this.link.setEndOffset(vector2D);
    }

    public void setLink(SLink sLink) {
        this.link = sLink;
    }

    public SLink getLink() {
        return this.link;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setLabel(String string) {
        this.pattern = string;
    }

    public void setLabelColor(Color color) {
        this.link.setLabelColor(color);
    }

    public void setLabelVisible(boolean bl) {
        if (this.link != null) {
            this.link.setLabelVisible(bl);
        }
    }

    public boolean isLabelVisible() {
        return this.link != null && this.link.isLabelVisible();
    }

    public void setShape(int n) {
        this.shape = n;
    }

    public int getShape() {
        return this.shape;
    }

    public void toggleShape() {
        switch (this.shape) {
            case 0: {
                this.shape = 1;
                break;
            }
            case 1: {
                this.shape = 0;
                break;
            }
            case 2: {
                return;
            }
        }
        double d = this.link.getFlateness();
        Vector2D vector2D = this.link.getDirection();
        this.link = this.createLinkInstance();
        this.link.setFlateness(d);
        this.link.setDirection(vector2D);
    }

    public void setMousePosition(Point point) {
        this.link.setDirection(Vector2D.vector(point).sub(this.target.getPosition()));
        this.link.setMousePosition(Vector2D.vector(point));
    }

    public Rect getFrame() {
        this.update();
        return this.link.getFrame();
    }

    public boolean isInside(Point point) {
        return this.link != null && this.link.contains(point.x, point.y);
    }

    public void update() {
        this.initializeLink(0.0);
        this.source.updateAnchors();
        this.target.updateAnchors();
        this.link.setStartAnchor(this.source.getAnchor(this.sourceAnchorKey));
        this.link.setEndAnchor(this.target.getAnchor(this.targetAnchorKey));
        this.link.setLabel(this.pattern);
        this.link.setSelfLoop(this.source == this.target);
        this.link.update();
    }

    public void draw(Graphics2D graphics2D) {
        this.update();
        if (this.isVisibleInClip(graphics2D)) {
            graphics2D.setStroke(new BasicStroke(this.penSize));
            if (this.color != null) {
                this.link.setColor(this.color);
            } else {
                this.link.setColor(Color.black);
            }
            this.link.draw(graphics2D);
        }
    }

    public void drawShape(Graphics2D graphics2D) {
        this.link.drawShape(graphics2D);
    }
}

