/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GElementRect
extends GElement
implements XJXMLSerializable {
    public static final int DEFAULT_WIDTH = 40;
    public static final int DEFAULT_HEIGHT = 40;
    protected double width = 40.0;
    protected double height = 40.0;

    public void setPositionOfUpperLeftCorner(double d, double d2) {
        this.setPosition(d + this.width * 0.5, d2 + this.height * 0.5);
    }

    public void setSize(double d, double d2) {
        this.width = d;
        this.height = d2;
        this.elementDimensionDidChange();
    }

    public void setWidth(double d) {
        this.width = d;
        this.elementDimensionDidChange();
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double d) {
        this.height = d;
        this.elementDimensionDidChange();
    }

    public double getHeight() {
        return this.height;
    }

    public void updateAnchors() {
        this.setAnchor("CENTER", this.position.copy(), Anchor2D.DIRECTION_FREE);
        this.setAnchor("TOP", new Vector2D(0.0, -this.height * 0.5).append(this.position), Anchor2D.DIRECTION_TOP);
        this.setAnchor("BOTTOM", new Vector2D(0.0, this.height * 0.5).append(this.position), Anchor2D.DIRECTION_BOTTOM);
        this.setAnchor("LEFT", new Vector2D(-this.width * 0.5, 0.0).append(this.position), Anchor2D.DIRECTION_LEFT);
        this.setAnchor("RIGHT", new Vector2D(this.width * 0.5, 0.0).append(this.position), Anchor2D.DIRECTION_RIGHT);
    }

    public Rect getFrame() {
        double d = this.getPositionX() - this.getWidth() * 0.5;
        double d2 = this.getPositionY() - this.getHeight() * 0.5;
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        return new Rect(d, d2, d3, d4);
    }

    public boolean isInside(Point point) {
        return this.getFrame().contains(point);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.isVisibleInClip(graphics2D)) {
            if (this.labelVisible) {
                graphics2D.setColor(this.labelColor);
                if (this.label != null && this.label.length() > 0) {
                    this.drawLabel(graphics2D);
                }
            }
            graphics2D.setColor(this.color);
            graphics2D.setStroke(this.strokeSize);
            this.drawShape(graphics2D);
            graphics2D.setStroke(this.strokeNormal);
        }
    }

    public void drawShape(Graphics2D graphics2D) {
        super.drawShape(graphics2D);
        Rectangle rectangle = this.getFrame().rectangle();
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawLabel(Graphics2D graphics2D) {
        SLabel.drawCenteredString(this.label, (int)this.getPositionX(), (int)this.getPositionY(), graphics2D);
    }
}

