/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.shape.SLabel;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class GElementCircle
extends GElement
implements XJXMLSerializable {
    public static final int DEFAULT_RADIUS = 20;
    protected double radius = 20.0;

    public void setRadius(double d) {
        this.radius = d;
        this.elementDimensionDidChange();
    }

    public double getRadius() {
        return this.radius;
    }

    public void updateAnchors() {
        this.setAnchor("CENTER", this.position, Anchor2D.DIRECTION_FREE);
        this.setAnchor("TOP", this.position.add(new Vector2D(0.0, -this.radius)), Anchor2D.DIRECTION_TOP);
        this.setAnchor("BOTTOM", this.position.add(new Vector2D(0.0, this.radius)), Anchor2D.DIRECTION_BOTTOM);
        this.setAnchor("LEFT", this.position.add(new Vector2D(-this.radius, 0.0)), Anchor2D.DIRECTION_LEFT);
        this.setAnchor("RIGHT", this.position.add(new Vector2D(this.radius, 0.0)), Anchor2D.DIRECTION_RIGHT);
    }

    public double getDefaultAnchorOffset(String string) {
        if (string != null && string.equals("CENTER")) {
            return this.radius;
        }
        return 0.0;
    }

    public Rect getFrame() {
        double d = this.getPositionX() - this.radius;
        double d2 = this.getPositionY() - this.radius;
        double d3 = this.radius * 2.0;
        double d4 = this.radius * 2.0;
        return new Rect(d, d2, d3, d4);
    }

    public boolean isInside(Point point) {
        return Math.abs(point.getX() - this.getPositionX()) < this.radius && Math.abs(point.getY() - this.getPositionY()) < this.radius;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.isVisibleInClip(graphics2D)) {
            if (this.labelVisible) {
                graphics2D.setColor(this.labelColor);
                SLabel.drawCenteredString(this.getLabel(), (int)this.getPositionX(), (int)this.getPositionY(), graphics2D);
            }
            if (this.color != null) {
                graphics2D.setColor(this.color);
            } else {
                graphics2D.setColor(Color.black);
            }
            graphics2D.setStroke(this.strokeSize);
            this.drawShape(graphics2D);
            graphics2D.setStroke(this.strokeNormal);
        }
    }

    public void drawShape(Graphics2D graphics2D) {
        super.drawShape(graphics2D);
        int n = (int)(this.getPositionX() - this.radius);
        int n2 = (int)(this.getPositionY() - this.radius);
        graphics2D.drawOval(n, n2, (int)(this.radius * 2.0), (int)(this.radius * 2.0));
    }
}

