/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.object;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.foundation.XJXMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GElement
implements XJXMLSerializable {
    public static final String ANCHOR_CENTER = "CENTER";
    public static final String ANCHOR_TOP = "TOP";
    public static final String ANCHOR_BOTTOM = "BOTTOM";
    public static final String ANCHOR_LEFT = "LEFT";
    public static final String ANCHOR_RIGHT = "RIGHT";
    protected transient GView view = null;
    protected List<GElement> elements = new ArrayList<GElement>();
    protected Vector2D position = new Vector2D();
    protected transient Vector2D oldPosition = null;
    protected transient Map<String, Anchor2D> anchors = new HashMap<String, Anchor2D>();
    protected String label = null;
    protected Color labelColor = Color.black;
    protected boolean labelVisible = true;
    protected transient boolean selected = false;
    protected transient boolean focused = false;
    protected transient Color color = Color.black;
    protected transient int penSize = 1;
    protected transient BasicStroke strokeSize = new BasicStroke(this.penSize);
    protected transient BasicStroke strokeNormal = new BasicStroke(1.0f);
    protected transient BasicStroke strokeBold = new BasicStroke(3.0f);
    protected boolean draggable = false;
    protected final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanel(GView gView) {
        this.view = gView;
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                gElement.setPanel(gView);
            }
        }
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isLabelEqualsTo(String string) {
        if (this.label == null) {
            return string == null;
        }
        return this.label.equals(string);
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setPosition(double d, double d2) {
        this.position.setX(d);
        this.position.setY(d2);
        this.elementPositionDidChange();
    }

    public double getPositionX() {
        return this.position.getX();
    }

    public double getPositionY() {
        return this.position.getY();
    }

    public void setPosition(Vector2D vector2D) {
        this.position = vector2D;
        this.elementPositionDidChange();
    }

    public Vector2D getPosition() {
        return this.position;
    }

    public void setElements(List<GElement> list) {
        this.elements = list;
    }

    public List<GElement> getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(GElement gElement) {
        gElement.setPanel(this.view);
        Object object = this.lock;
        synchronized (object) {
            this.elements.add(gElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(GElement gElement) {
        Object object = this.lock;
        synchronized (object) {
            this.elements.remove(gElement);
        }
    }

    public GElement getFirstElement() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(0);
    }

    public GElement getLastElement() {
        if (this.elements == null || this.elements.isEmpty()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public GElement findElementWithLabel(String string) {
        if (this.isLabelEqualsTo(string)) {
            return this;
        }
        if (this.elements == null) {
            return null;
        }
        for (GElement gElement : this.elements) {
            if (gElement.isLabelEqualsTo(string)) {
                return gElement;
            }
            if ((gElement = gElement.findElementWithLabel(string)) == null) continue;
            return gElement;
        }
        return null;
    }

    public void updateAnchors() {
    }

    public void setAnchor(String string, Vector2D vector2D, Vector2D vector2D2) {
        Anchor2D anchor2D = this.getAnchor(string);
        if (anchor2D == null) {
            anchor2D = new Anchor2D();
            this.anchors.put(string, anchor2D);
        }
        anchor2D.setPosition(vector2D);
        anchor2D.setDirection(vector2D2);
    }

    public double getDefaultAnchorOffset(String string) {
        return 0.0;
    }

    public Anchor2D getAnchor(String string) {
        return this.anchors.get(string);
    }

    public String getAnchorKeyClosestToPoint(Point point) {
        Anchor2D anchor2D = this.getAnchorClosestToPoint(point);
        for (String string : this.anchors.keySet()) {
            if (this.anchors.get(string) != anchor2D) continue;
            return string;
        }
        return null;
    }

    public Anchor2D getAnchorClosestToPoint(Point point) {
        double d = 2.147483647E9;
        Anchor2D anchor2D = null;
        for (Anchor2D anchor2D2 : this.anchors.values()) {
            double d2;
            double d3 = anchor2D2.position.getX() - (double)point.x;
            double d4 = Math.sqrt(d3 * d3 + (d2 = anchor2D2.position.getY() - (double)point.y) * d2);
            if (!(d4 < d)) continue;
            d = d4;
            anchor2D = anchor2D2;
        }
        return anchor2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect bounds() {
        Rect rect = this.getFrame();
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                if (gElement == this) continue;
                if (rect == null) {
                    rect = gElement.bounds();
                    continue;
                }
                rect = rect.union(gElement.bounds());
            }
        }
        return rect;
    }

    public Rect getFrame() {
        return null;
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean acceptIncomingLink() {
        return false;
    }

    public boolean acceptOutgoingLink() {
        return false;
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPenSize(int n) {
        this.penSize = n;
        this.strokeSize = new BasicStroke(this.penSize);
    }

    public boolean isInside(Point point) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(double d, double d2) {
        this.position.shift(d, d2);
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                gElement.move(d, d2);
            }
        }
        this.elementPositionDidChange();
    }

    public void moveToPosition(Vector2D vector2D) {
        double d = vector2D.x - this.getPosition().x;
        double d2 = vector2D.y - this.getPosition().y;
        this.move(d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GElement match(Point point) {
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                GElement gElement2 = gElement.match(point);
                if (gElement2 == null) continue;
                return gElement2;
            }
        }
        if (this.isInside(point)) {
            return this;
        }
        return null;
    }

    public void beginDrag() {
        this.oldPosition = null;
    }

    public Vector2D dragElementPosition(Vector2D vector2D) {
        Vector2D vector2D2 = vector2D.copy();
        if (this.oldPosition != null) {
            vector2D2.x += vector2D.x - this.oldPosition.x;
            vector2D2.y += vector2D.y - this.oldPosition.y;
        }
        return vector2D2;
    }

    public void drag(Vector2D vector2D) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.oldPosition == null) {
            this.oldPosition = new Vector2D();
        } else {
            d = vector2D.x - this.oldPosition.x;
            d2 = vector2D.y - this.oldPosition.y;
        }
        this.oldPosition.x = vector2D.x;
        this.oldPosition.y = vector2D.y;
        this.move(d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRecursive(Graphics2D graphics2D) {
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                gElement.drawRecursive(graphics2D);
            }
        }
        this.draw(graphics2D);
        if (this.isSelected()) {
            this.drawSelected(graphics2D);
        } else if (this.isFocused()) {
            this.drawFocused(graphics2D);
        }
    }

    public boolean isVisibleInClip(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle == null) {
            return true;
        }
        Rectangle rectangle2 = this.getFrame().rectangle();
        ++rectangle2.width;
        ++rectangle2.height;
        return rectangle.intersects(rectangle2);
    }

    public void draw(Graphics2D graphics2D) {
    }

    public void drawShape(Graphics2D graphics2D) {
    }

    private void drawSelected(Graphics2D graphics2D) {
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.view.getSelectionAlphaValue()));
        graphics2D.setColor(Color.gray);
        graphics2D.setStroke(this.strokeBold);
        this.drawShape(graphics2D);
        graphics2D.setStroke(this.strokeNormal);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void drawFocused(Graphics2D graphics2D) {
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.view.getFocusAlphaValue()));
        graphics2D.setColor(Color.blue);
        graphics2D.setStroke(this.strokeBold);
        this.drawShape(graphics2D);
        graphics2D.setStroke(this.strokeNormal);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void elementPositionDidChange() {
        this.updateAnchors();
    }

    public void elementDimensionDidChange() {
        this.updateAnchors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void elementDidLoad() {
        Object object = this.lock;
        synchronized (object) {
            for (GElement gElement : this.elements) {
                gElement.elementDidLoad();
            }
        }
        this.updateAnchors();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.position.x + "/" + this.position.y;
    }
}

