/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventDelegate;
import org.antlr.xjlib.appkit.gview.object.GElement;

public class GEventManager {
    private List<GAbstractEvent> eventObjects = new ArrayList<GAbstractEvent>();
    private Set exclusiveValueSet = new HashSet();
    private GEventDelegate eventDelegate = null;
    public static final int EVENT_DRAW = 1;
    public static final int EVENT_MOUSE_PRESSED = 2;
    public static final int EVENT_MOUSE_RELEASED = 3;
    public static final int EVENT_MOUSE_DRAGGED = 4;
    public static final int EVENT_MOUSE_MOVED = 5;
    public static final Integer EXCLUSIVE_DRAG_VALUE = new Integer(99);
    public static final Integer EXCLUSIVE_CREATE_LINK_VALUE = new Integer(100);

    public GEventManager(GEventDelegate gEventDelegate) {
        this.eventDelegate = gEventDelegate;
    }

    public void add(GAbstractEvent gAbstractEvent) {
        gAbstractEvent.setManager(this);
        gAbstractEvent.setDelegate(this.eventDelegate);
        this.eventObjects.add(gAbstractEvent);
    }

    public boolean canFocusOnElement(GElement gElement) {
        for (GAbstractEvent gAbstractEvent : this.eventObjects) {
            if (gAbstractEvent.shouldFocusOnElement(gElement)) continue;
            return false;
        }
        return true;
    }

    public void addExclusiveValue(Object object) {
        this.exclusiveValueSet.add(object);
    }

    public void removeExclusiveValue(Object object) {
        this.exclusiveValueSet.remove(object);
    }

    public boolean hasExclusiveValue(Object object) {
        return this.exclusiveValueSet.contains(object);
    }

    public void performEventObjects(int n, Object object, Point point, Object object2) {
        for (GAbstractEvent gAbstractEvent : this.eventObjects) {
            switch (n) {
                case 1: {
                    gAbstractEvent.draw((Graphics)object2);
                    break;
                }
                case 2: {
                    gAbstractEvent.mousePressed((MouseEvent)object, point);
                    break;
                }
                case 3: {
                    gAbstractEvent.mouseReleased((MouseEvent)object, point);
                    break;
                }
                case 4: {
                    gAbstractEvent.mouseDragged((MouseEvent)object, point);
                    break;
                }
                case 5: {
                    gAbstractEvent.mouseMoved((MouseEvent)object, point);
                }
            }
        }
    }
}

