/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;

public class GEventDragSelection
extends GAbstractEvent {
    private boolean selecting = false;
    private Point p1 = null;
    private Point p2 = null;

    public GEventDragSelection(GView gView) {
        super(gView);
    }

    public void mousePressed(MouseEvent mouseEvent, Point point) {
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE)) {
            return;
        }
        if (mouseEvent.getClickCount() != 1) {
            return;
        }
        int n = 1024;
        if ((mouseEvent.getModifiersEx() & n) == n && this.delegate.eventQueryElementAtPoint(point) == null) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.selecting = true;
            this.delegate.eventSouldSelectAllElements(false);
            this.p1 = point;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent, Point point) {
        this.removeExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
        this.delegate.eventShouldRepaint();
        this.selecting = false;
        this.p1 = null;
        this.p2 = null;
    }

    public void mouseDragged(MouseEvent mouseEvent, Point point) {
        if (!this.selecting) {
            return;
        }
        this.p2 = point;
        this.delegate.eventSelectElementsInRect(this.p1.x, this.p1.y, this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        this.delegate.eventShouldRepaint();
    }

    public void draw(Graphics graphics) {
        if (this.selecting && this.p1 != null && this.p2 != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = Math.min(this.p1.x, this.p2.x);
            int n2 = Math.min(this.p1.y, this.p2.y);
            int n3 = Math.abs(this.p2.x - this.p1.x);
            int n4 = Math.abs(this.p2.y - this.p1.y);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics.setColor(Color.gray);
            graphics.fillRect(n, n2, n3, n4);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics.setColor(Color.black);
            graphics.drawRect(n, n2, n3, n4);
        }
    }
}

