/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.object.GElement;

public class GEventDragElement
extends GAbstractEvent {
    public GElement dragElement = null;
    protected boolean dragging = false;
    protected Point p1 = null;
    protected Point p2 = null;
    protected Vector2D dragElementOffset = null;

    public GEventDragElement(GView gView) {
        super(gView);
    }

    public void mousePressed(MouseEvent mouseEvent, Point point) {
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE)) {
            return;
        }
        if (this.hasExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE)) {
            return;
        }
        if (mouseEvent.getClickCount() != 1) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x40) == 64) {
            return;
        }
        this.dragElement = this.delegate.eventQueryElementAtPoint(point);
        if (this.dragElement != null && this.delegate.eventIsSelectedElement(this.dragElement)) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.dragging = true;
            this.p1 = point;
        } else if (this.dragElement != null && this.dragElement.isDraggable()) {
            this.addExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
            this.dragElement.beginDrag();
            this.dragElementOffset = Vector2D.vector(point).sub(this.dragElement.getPosition());
            return;
        }
        this.dragElement = null;
    }

    public void mouseReleased(MouseEvent mouseEvent, Point point) {
        this.removeExclusiveValue(GEventManager.EXCLUSIVE_DRAG_VALUE);
        this.view.hideAllMagnetics();
        this.dragElement = null;
        this.dragging = false;
    }

    public void mouseDragged(MouseEvent mouseEvent, Point point) {
        if (this.dragElement != null) {
            Vector2D vector2D = Vector2D.vector(point);
            Vector2D vector2D2 = vector2D.sub(this.dragElementOffset);
            this.view.showAndAjustPositionToMagnetics(vector2D2);
            this.dragElement.moveToPosition(vector2D2);
            this.delegate.eventChangeDone();
            this.delegate.eventShouldRepaint();
        } else if (this.dragging) {
            this.p2 = point;
            this.delegate.eventMoveSelectedElements(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
            this.p1 = this.p2;
            this.delegate.eventChangeDone();
            this.delegate.eventShouldRepaint();
        }
    }
}

