/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.event;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.antlr.xjlib.appkit.gview.GView;
import org.antlr.xjlib.appkit.gview.base.Anchor2D;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GAbstractEvent;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.shape.SLink;
import org.antlr.xjlib.appkit.gview.shape.SLinkArc;
import org.antlr.xjlib.appkit.gview.shape.SLinkElbow;

public class GEventCreateLinkElement
extends GAbstractEvent {
    public GElement startElement = null;
    public String startAnchorKey = null;
    public SLink linkElement = null;
    public SLinkArc linkArc = null;
    public SLinkElbow linkElbow = null;

    public GEventCreateLinkElement(GView gView) {
        super(gView);
    }

    public void mousePressed(MouseEvent mouseEvent, Point point) {
        GElement gElement = this.delegate.eventQueryElementAtPoint(point);
        if (this.startElement != null) {
            if (gElement != null) {
                int n = this.linkElement instanceof SLinkElbow ? 1 : 0;
                this.delegate.eventCreateLink(this.startElement, this.startAnchorKey, gElement, gElement.getAnchorKeyClosestToPoint(point), n, point);
            }
            this.removeExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE);
            this.startElement = null;
            this.linkElement = null;
            this.delegate.eventShouldRepaint();
            return;
        }
        if (gElement == null || !gElement.acceptOutgoingLink()) {
            return;
        }
        int n = 1088;
        if ((mouseEvent.getModifiersEx() & n) == n || this.delegate.eventCanCreateLink()) {
            this.startElement = gElement;
            this.startAnchorKey = this.startElement.getAnchorKeyClosestToPoint(point);
            this.linkArc = new SLinkArc();
            this.linkArc.setStartTangentOffset(this.startElement.getDefaultAnchorOffset(this.startAnchorKey));
            this.linkElbow = new SLinkElbow();
            this.linkElement = this.view.defaultLinkShape() == 0 ? this.linkArc : this.linkElbow;
            this.linkElement.setFlateness(this.delegate.eventLinkFlateness());
            this.addExclusiveValue(GEventManager.EXCLUSIVE_CREATE_LINK_VALUE);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, Point point) {
        if (this.startElement == null) {
            return;
        }
        this.updateLink(point);
        this.delegate.eventShouldRepaint();
    }

    public boolean shouldFocusOnElement(GElement gElement) {
        if (this.startElement == null) {
            return true;
        }
        return gElement.acceptIncomingLink();
    }

    public void updateLink(Point point) {
        GElement gElement = this.delegate.eventQueryElementAtPoint(point);
        boolean bl = gElement == this.startElement;
        this.setLinkStartAnchor(this.startElement.getAnchor(this.startAnchorKey));
        if (gElement == null || gElement instanceof GLink) {
            this.setLinkEnd(Vector2D.vector(point), Anchor2D.DIRECTION_BOTTOM);
        } else {
            Anchor2D anchor2D = gElement.getAnchorClosestToPoint(point);
            String string = gElement.getAnchorKeyClosestToPoint(point);
            this.setLinkEnd(anchor2D.position, anchor2D.direction);
            if (bl) {
                if (anchor2D.direction == Anchor2D.DIRECTION_FREE) {
                    this.linkArc.setMouse(point);
                } else {
                    this.linkArc.setMouse(anchor2D.position.add(anchor2D.direction));
                }
                this.linkArc.setEndTangentOffset(this.startElement.getDefaultAnchorOffset(string));
            } else {
                this.linkArc.setMouse(point);
                this.linkArc.setEndTangentOffset(gElement.getDefaultAnchorOffset(string));
            }
            if (bl && this.view.defaultLinkShape() == 1 && this.startElement.getAnchor(this.startAnchorKey).equals(anchor2D)) {
                this.linkElement = this.linkArc;
            } else if (this.view.defaultLinkShape() == 1) {
                this.linkElement = this.linkElbow;
            } else if (this.view.defaultLinkShape() == 0) {
                this.linkElement = this.linkArc;
            }
        }
        this.setLinkSelfLoop(bl);
        this.linkElement.update();
    }

    private void setLinkSelfLoop(boolean bl) {
        this.linkArc.setSelfLoop(bl);
        this.linkElbow.setSelfLoop(bl);
    }

    private void setLinkStartAnchor(Anchor2D anchor2D) {
        this.linkArc.setStartAnchor(anchor2D);
        this.linkElbow.setStartAnchor(anchor2D);
    }

    private void setLinkEnd(Vector2D vector2D, Vector2D vector2D2) {
        this.linkArc.setEnd(vector2D);
        this.linkArc.setEndDirection(vector2D2);
        this.linkElbow.setEnd(vector2D);
        this.linkElbow.setEndDirection(vector2D2);
    }

    public void draw(Graphics graphics) {
        if (this.linkElement == null) {
            return;
        }
        this.linkElement.draw((Graphics2D)graphics);
    }
}

