/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Point;
import java.awt.geom.Point2D;
import org.antlr.xjlib.foundation.XJXMLSerializable;

public class Vector2D
implements XJXMLSerializable {
    public double x = 0.0;
    public double y = 0.0;

    public static Vector2D vector(Point point) {
        return new Vector2D(point.x, point.y);
    }

    public static Vector2D vector(Point2D point2D) {
        return new Vector2D(point2D.getX(), point2D.getY());
    }

    public Vector2D() {
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D setLength(double d) {
        double d2 = this.length();
        if (d2 == 0.0) {
            this.x = 0.0;
            this.y = 0.0;
        } else {
            this.x = this.x / d2 * d;
            this.y = this.y / d2 * d;
        }
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D stretch(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public Vector2D shift(double d, double d2) {
        this.x += d;
        this.y += d2;
        return this;
    }

    public Vector2D vectorLength(double d) {
        Vector2D vector2D = this.copy();
        vector2D.setLength(d);
        return vector2D;
    }

    public Vector2D rotate(double d) {
        if (Math.abs(d) == 90.0) {
            double d2 = this.x;
            this.x = this.y;
            this.y = d2;
            if (d < 0.0) {
                this.y = -this.y;
            } else {
                this.x = -this.x;
            }
        } else {
            double d3 = Math.toRadians(d);
            double d4 = Math.cos(d3) * this.x - Math.sin(d3) * this.y;
            double d5 = Math.sin(d3) * this.x + Math.cos(d3) * this.y;
            this.x = d4;
            this.y = d5;
        }
        return this;
    }

    public Vector2D normalize() {
        double d = this.length();
        if (d == 0.0) {
            return new Vector2D();
        }
        return new Vector2D(this.x / d, this.y / d);
    }

    public Vector2D append(Vector2D vector2D) {
        this.setX(this.x + vector2D.x);
        this.setY(this.y + vector2D.y);
        return this;
    }

    public Vector2D add(Vector2D vector2D) {
        return new Vector2D(this.x + vector2D.x, this.y + vector2D.y);
    }

    public Vector2D sub(Vector2D vector2D) {
        return new Vector2D(this.x - vector2D.x, this.y - vector2D.y);
    }

    public double dot(Vector2D vector2D) {
        return this.x * vector2D.x + this.y * vector2D.y;
    }

    public double cross(Vector2D vector2D) {
        return this.x * vector2D.y - this.y * vector2D.x;
    }

    public int crossSign(Vector2D vector2D) {
        double d = this.cross(vector2D);
        if (d == 0.0) {
            return 0;
        }
        return d < 0.0 ? -1 : 1;
    }

    public Point toPoint() {
        return new Point((int)this.x, (int)this.y);
    }

    public boolean equals(Object object) {
        if (object instanceof Vector2D) {
            Vector2D vector2D = (Vector2D)object;
            return vector2D.x == this.x && vector2D.y == this.y;
        }
        return false;
    }

    public String toString() {
        return "<Vector2D: " + this.x + ", " + this.y + " >";
    }

    public Vector2D copy() {
        return new Vector2D(this.x, this.y);
    }
}

