/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class Rect {
    public Rectangle r;

    public Rect(Rectangle rectangle) {
        this.r = rectangle;
    }

    public Rect(Vector2D vector2D, Vector2D vector2D2) {
        this.create(vector2D, vector2D2, 0.0, 0.0);
    }

    public Rect(Vector2D vector2D, Vector2D vector2D2, double d, double d2) {
        this.create(vector2D, vector2D2, d, d2);
    }

    public void create(Vector2D vector2D, Vector2D vector2D2, double d, double d2) {
        double d3 = Math.min(vector2D.getX(), vector2D2.getX());
        double d4 = Math.min(vector2D.getY(), vector2D2.getY());
        double d5 = Math.max(d, Math.abs(vector2D.getX() - vector2D2.getX()));
        double d6 = Math.max(d2, Math.abs(vector2D.getY() - vector2D2.getY()));
        this.r = new Rectangle((int)d3, (int)d4, (int)d5, (int)d6);
    }

    public Rect(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            d += d3;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        this.r = new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
    }

    public Rect union(Rect rect) {
        return new Rect((Rectangle)this.rectangle().createUnion(rect.rectangle()));
    }

    public Rectangle rectangle() {
        return this.r;
    }

    public static boolean intersect(Rect rect, Rect rect2) {
        return rect.rectangle().intersects(rect2.rectangle());
    }

    public boolean contains(double d, double d2) {
        return this.r.contains(d, d2);
    }

    public boolean contains(Point point) {
        return this.r.contains(point);
    }

    public void inset(double d) {
        this.r.x = (int)((double)this.r.x + d);
        this.r.y = (int)((double)this.r.y + d);
        this.r.width = (int)((double)this.r.width - 2.0 * d);
        this.r.height = (int)((double)this.r.height - 2.0 * d);
    }

    public String toString() {
        if (this.r == null) {
            return super.toString();
        }
        return this.r.toString();
    }
}

