/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview.base;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;

public class Path2D {
    private List<Vector2D> points = new ArrayList<Vector2D>();

    public void clear() {
        this.points.clear();
    }

    public void add(Vector2D vector2D) {
        this.points.add(vector2D);
    }

    public void add(double d, double d2) {
        this.add(new Vector2D(d, d2));
    }

    public void draw(Graphics graphics) {
        Vector2D vector2D = null;
        for (Vector2D vector2D2 : this.points) {
            if (vector2D != null) {
                graphics.drawLine((int)vector2D.getX(), (int)vector2D.getY(), (int)vector2D2.getX(), (int)vector2D2.getY());
            }
            vector2D = vector2D2;
        }
    }

    public boolean contains(double d, double d2) {
        Vector2D vector2D = null;
        for (Vector2D vector2D2 : this.points) {
            if (vector2D != null) {
                Rect rect = new Rect(vector2D, vector2D2);
                rect.inset(-4.0);
                if (rect.contains(d, d2)) {
                    return true;
                }
            }
            vector2D = vector2D2;
        }
        return false;
    }

    public Vector2D getEndDirection() {
        if (this.points.size() < 2) {
            return null;
        }
        Vector2D vector2D = this.points.get(this.points.size() - 2);
        Vector2D vector2D2 = this.points.get(this.points.size() - 1);
        return vector2D.sub(vector2D2);
    }
}

