/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.gview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.antlr.xjlib.appkit.frame.XJView;
import org.antlr.xjlib.appkit.gview.GViewDelegate;
import org.antlr.xjlib.appkit.gview.base.Rect;
import org.antlr.xjlib.appkit.gview.base.Vector2D;
import org.antlr.xjlib.appkit.gview.event.GEventCreateElement;
import org.antlr.xjlib.appkit.gview.event.GEventCreateLinkElement;
import org.antlr.xjlib.appkit.gview.event.GEventDelegate;
import org.antlr.xjlib.appkit.gview.event.GEventDragElement;
import org.antlr.xjlib.appkit.gview.event.GEventDragRootElement;
import org.antlr.xjlib.appkit.gview.event.GEventDragSelection;
import org.antlr.xjlib.appkit.gview.event.GEventEditElement;
import org.antlr.xjlib.appkit.gview.event.GEventFocusElement;
import org.antlr.xjlib.appkit.gview.event.GEventManager;
import org.antlr.xjlib.appkit.gview.event.GEventModifyLinkElement;
import org.antlr.xjlib.appkit.gview.object.GElement;
import org.antlr.xjlib.appkit.gview.object.GLink;
import org.antlr.xjlib.appkit.gview.timer.GTimer;
import org.antlr.xjlib.appkit.gview.timer.GTimerDelegate;
import org.antlr.xjlib.appkit.gview.utils.GAlphaVariator;
import org.antlr.xjlib.appkit.gview.utils.GMagnetic;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.swing.XJGraphics2DPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GView
extends XJView
implements XJMenuItemDelegate,
GTimerDelegate,
GEventDelegate {
    public static final double DEFAULT_LINK_FLATENESS = 40.0;
    public static final int SCROLL_TO_VISIBLE_MARGIN = 10;
    protected GViewDelegate delegate = null;
    protected GEventManager eventManager = new GEventManager(this);
    protected GElement rootElement = null;
    protected Point lastMousePosition = null;
    protected boolean smoothGraphics = true;
    protected float zoom = 1.0f;
    protected boolean autoAdjustSize = false;
    protected boolean drawBorder = true;
    protected int sizeMargin = 0;
    protected GTimer selectionTimer = new GTimer(this);
    protected GTimer focusTimer = new GTimer(this);
    protected GAlphaVariator selectionAlphaVariator = new GAlphaVariator();
    protected GAlphaVariator focusAlphaVariator = new GAlphaVariator();
    protected Set<GMagnetic> magnetics = new HashSet<GMagnetic>();
    protected boolean magneticsVisible = false;

    public GView() {
        this.setFocusable(false);
        this.setBackground(Color.gray);
        this.setPreferredSize(new Dimension(1024, 600));
        this.addDefaultEventManager();
    }

    public void addDefaultEventManager() {
        this.eventManager.add(new GEventDragElement(this));
        this.eventManager.add(new GEventDragRootElement(this));
        this.eventManager.add(new GEventDragSelection(this));
        this.eventManager.add(new GEventEditElement(this));
        this.eventManager.add(new GEventCreateLinkElement(this));
        this.eventManager.add(new GEventCreateElement(this));
        this.eventManager.add(new GEventFocusElement(this));
        this.eventManager.add(new GEventModifyLinkElement(this));
    }

    public int defaultLinkShape() {
        return 0;
    }

    public void setRootElement(GElement gElement) {
        this.rootElement = gElement;
        if (this.rootElement != null) {
            this.rootElement.setPanel(this);
            this.autoAdjustSize();
        }
    }

    public GElement getRootElement() {
        return this.rootElement;
    }

    public GEventManager getEventManager() {
        return this.eventManager;
    }

    public void setDelegate(GViewDelegate gViewDelegate) {
        this.delegate = gViewDelegate;
    }

    public void setSmoothGraphics(boolean bl) {
        this.smoothGraphics = bl;
    }

    public boolean getSmoothGraphics() {
        return this.smoothGraphics;
    }

    public void setAutoAdjustSize(boolean bl) {
        this.autoAdjustSize = bl;
    }

    public boolean getAutoAdjustSize() {
        return this.autoAdjustSize;
    }

    public float getSelectionAlphaValue() {
        return this.selectionAlphaVariator.getAlphaValue();
    }

    public float getFocusAlphaValue() {
        return this.focusAlphaVariator.getAlphaValue();
    }

    public Point getMousePosition(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (this.zoom != 1.0f) {
            return new Point((int)((float)point.x / this.zoom), (int)((float)point.y / this.zoom));
        }
        return point;
    }

    public Point getLastMousePosition() {
        return this.lastMousePosition;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setZoom(float f) {
        this.zoom = f;
        this.autoAdjustSize();
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setSizeMargin(int n) {
        this.sizeMargin = n;
    }

    public void setRealSize(Dimension dimension) {
        if (this.sizeMargin > 0) {
            dimension.width += this.sizeMargin;
            dimension.height += this.sizeMargin;
        }
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.revalidate();
    }

    public void setRealSize(int n, int n2) {
        this.setRealSize(new Dimension(n, n2));
    }

    public Dimension getRealSize() {
        return this.getPreferredSize();
    }

    public void autoAdjustSize() {
        if (this.rootElement == null || !this.autoAdjustSize) {
            return;
        }
        Rect rect = this.rootElement.bounds();
        this.setRealSize((int)((float)(rect.r.x + rect.r.width) * this.zoom), (int)((float)(rect.r.y + rect.r.height) * this.zoom));
        if (this.delegate != null) {
            this.delegate.viewSizeDidChange();
        }
    }

    public void centerAll() {
        if (this.rootElement == null) {
            return;
        }
        Dimension dimension = this.getRealSize();
        if (dimension.width == 0 && dimension.height == 0) {
            dimension = this.getPreferredSize();
        }
        Rectangle rectangle = this.rootElement.bounds().rectangle();
        double d = (double)(dimension.width - rectangle.width) * 0.5;
        double d2 = (double)(dimension.height - rectangle.height) * 0.5;
        this.rootElement.move(d - (double)rectangle.x, d2 - (double)rectangle.y);
    }

    public void setMagneticsVisible(boolean bl) {
        this.magneticsVisible = bl;
        this.repaint();
    }

    public boolean isMagneticsVisible() {
        return this.magneticsVisible;
    }

    public void toggleShowMagnetics() {
        this.setMagneticsVisible(!this.isMagneticsVisible());
    }

    public void createMagnetics() {
        int n;
        this.magnetics.clear();
        double d = 0.0;
        for (n = 0; n < this.delegate.getHorizontalMagnetics(); ++n) {
            this.magnetics.add(GMagnetic.createHorizontal(d += 1.0 / (double)(this.delegate.getHorizontalMagnetics() + 1)));
        }
        d = 0.0;
        for (n = 0; n < this.delegate.getVerticalMagnetics(); ++n) {
            this.magnetics.add(GMagnetic.createVertical(d += 1.0 / (double)(this.delegate.getVerticalMagnetics() + 1)));
        }
    }

    public void showAndAjustPositionToMagnetics(Vector2D vector2D) {
        for (GMagnetic gMagnetic : this.magnetics) {
            gMagnetic.showAndAjust(vector2D, this.getRealSize());
        }
    }

    public void hideAllMagnetics() {
        for (GMagnetic gMagnetic : this.magnetics) {
            gMagnetic.setVisible(false);
        }
    }

    public void scrollElementToVisible(GElement gElement) {
        Rect rect = gElement.getFrame();
        Rectangle rectangle = rect == null ? new Rectangle((int)gElement.getPositionX(), (int)gElement.getPositionY(), 1, 1) : rect.r;
        rectangle.x = (int)((float)rectangle.x * this.zoom);
        rectangle.y = (int)((float)rectangle.y * this.zoom);
        rectangle.width = (int)((float)rectangle.width * this.zoom);
        rectangle.height = (int)((float)rectangle.height * this.zoom);
        rectangle.x -= 10;
        rectangle.y -= 10;
        rectangle.width += 20;
        rectangle.height += 20;
        this.scrollRectToVisible(rectangle);
    }

    public void addSelectedElement(GElement gElement) {
        this.selectionTimer.add(gElement);
    }

    public void removeSelectedElement(GElement gElement) {
        this.selectionTimer.remove(gElement);
    }

    public void addFocusedElement(GElement gElement) {
        this.focusTimer.add(gElement);
    }

    public void removeFocusedElement(GElement gElement) {
        this.focusTimer.remove(gElement);
    }

    public BufferedImage getImage() {
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.rootElement.drawRecursive(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public String getEPS() {
        XJGraphics2DPS xJGraphics2DPS = new XJGraphics2DPS();
        xJGraphics2DPS.setMargins(6, 6);
        this.rootElement.drawRecursive(xJGraphics2DPS);
        return xJGraphics2DPS.getPSText();
    }

    public Image makeColorTransparent(Image image, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            public int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public void drawMagnetics(Graphics2D graphics2D) {
        graphics2D.setColor(Color.yellow);
        for (GMagnetic gMagnetic : this.magnetics) {
            if (!this.magneticsVisible && !gMagnetic.isVisible()) continue;
            gMagnetic.draw(graphics2D, this.getRealSize());
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.smoothGraphics) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.drawBorder) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            graphics2D.setColor(Color.darkGray);
            graphics2D.drawRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            graphics2D.clipRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        }
        graphics2D.scale(this.zoom, this.zoom);
        this.drawMagnetics(graphics2D);
        if (this.rootElement != null) {
            this.rootElement.drawRecursive(graphics2D);
        }
        this.eventManager.performEventObjects(1, null, null, graphics);
    }

    public void addMenuItem(JPopupMenu jPopupMenu, String string, int n, Object object) {
        XJMenuItem xJMenuItem = new XJMenuItem();
        xJMenuItem.setTitle(string);
        xJMenuItem.setTag(n);
        xJMenuItem.setObject(object);
        xJMenuItem.setDelegate(this);
        jPopupMenu.add(xJMenuItem.getSwingComponent());
    }

    public JPopupMenu getContextualMenu(GElement gElement) {
        return null;
    }

    public List<GElement> getSelectedElements() {
        return this.selectionTimer.getElements();
    }

    public GElement getElementAtMousePosition(MouseEvent mouseEvent) {
        return this.getElementAtPoint(this.getMousePosition(mouseEvent));
    }

    public GElement getElementAtPoint(Point point) {
        if (this.rootElement != null) {
            return this.rootElement.match(point);
        }
        return null;
    }

    public void changeDone() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.changeOccured();
    }

    public void selectElementsInRect(int n, int n2, int n3, int n4) {
        Rect rect = new Rect(n, n2, (double)n3, (double)n4);
        if (this.rootElement == null || this.rootElement.getElements() == null) {
            return;
        }
        for (GElement gElement : this.rootElement.getElements()) {
            boolean bl = Rect.intersect(rect, gElement.bounds());
            gElement.setSelected(bl);
            if (bl) {
                this.addSelectedElement(gElement);
                continue;
            }
            this.removeSelectedElement(gElement);
        }
    }

    public void selectAllElements(boolean bl) {
        if (this.rootElement == null) {
            return;
        }
        for (GElement gElement : this.rootElement.getElements()) {
            gElement.setSelected(bl);
            if (bl) {
                this.addSelectedElement(gElement);
                continue;
            }
            this.removeSelectedElement(gElement);
        }
    }

    public void moveSelectedElements(double d, double d2) {
        for (GElement gElement : this.selectionTimer.getElements()) {
            gElement.move(d, d2);
        }
        this.autoAdjustSize();
    }

    @Override
    public void timerFired(GTimer gTimer) {
        if (gTimer == this.selectionTimer) {
            this.selectionAlphaVariator.run();
        } else if (gTimer == this.focusTimer) {
            this.focusAlphaVariator.run();
        }
        this.repaint();
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.getContextualMenu(this.getElementAtPoint(this.getMousePosition(mouseEvent)));
            if (jPopupMenu != null) {
                this.requestFocus();
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                this.lastMousePosition = this.getMousePosition(mouseEvent);
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    @Override
    public void handleMousePressed(MouseEvent mouseEvent) {
        this.eventManager.performEventObjects(2, mouseEvent, this.getMousePosition(mouseEvent), null);
    }

    @Override
    public void handleMouseReleased(MouseEvent mouseEvent) {
        this.eventManager.performEventObjects(3, mouseEvent, this.getMousePosition(mouseEvent), null);
    }

    @Override
    public void handleMouseDragged(MouseEvent mouseEvent) {
        this.eventManager.performEventObjects(4, mouseEvent, this.getMousePosition(mouseEvent), null);
    }

    @Override
    public void handleMouseMoved(MouseEvent mouseEvent) {
        this.eventManager.performEventObjects(5, mouseEvent, this.getMousePosition(mouseEvent), null);
        if (this.delegate != null) {
            this.delegate.contextualHelp(this.getElementAtPoint(this.getMousePosition(mouseEvent)));
        }
    }

    @Override
    public void handleMouseEntered(MouseEvent mouseEvent) {
        this.selectionTimer.refresh();
        this.focusTimer.refresh();
    }

    @Override
    public void handleMouseExited(MouseEvent mouseEvent) {
        this.selectionTimer.stop();
        this.focusTimer.stop();
    }

    @Override
    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
    }

    @Override
    public void eventChangeDone() {
        this.autoAdjustSize();
        this.changeDone();
    }

    @Override
    public void eventShouldRepaint() {
        this.repaint();
    }

    @Override
    public GElement eventQueryElementAtPoint(Point point) {
        return this.getElementAtPoint(point);
    }

    @Override
    public GElement eventQueryRootElement() {
        return this.rootElement;
    }

    @Override
    public void eventSouldSelectAllElements(boolean bl) {
        this.selectAllElements(bl);
    }

    @Override
    public void eventMoveSelectedElements(int n, int n2) {
        this.moveSelectedElements(n, n2);
    }

    @Override
    public void eventCreateElement(Point point, boolean bl) {
    }

    @Override
    public void eventEditElement(GElement gElement) {
    }

    @Override
    public boolean eventCanCreateLink() {
        return false;
    }

    @Override
    public double eventLinkFlateness() {
        return 40.0;
    }

    @Override
    public void eventCreateLink(GElement gElement, String string, GElement gElement2, String string2, int n, Point point) {
        this.rootElement.addElement(new GLink(gElement, string, gElement2, string2, n, "", point, 40.0));
    }

    @Override
    public void eventSelectElementsInRect(int n, int n2, int n3, int n4) {
        this.selectElementsInRect(n, n2, n3, n4);
    }

    @Override
    public void eventAddFocusedElement(GElement gElement) {
        this.addFocusedElement(gElement);
    }

    @Override
    public void eventRemoveFocusedElement(GElement gElement) {
        this.removeFocusedElement(gElement);
    }

    @Override
    public boolean eventIsSelectedElement(GElement gElement) {
        return this.selectionTimer.contains(gElement);
    }

    public class MyContextualMenuListener
    implements PopupMenuListener {
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            GView.this.repaint();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

