/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJData;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;

public class XJWindow
extends XJFrame {
    protected XJDocument document = null;

    public XJWindow() {
        XJApplication.shared().addWindow(this);
        this.setDefaultCloseOperation(0);
    }

    public boolean isAuxiliaryWindow() {
        return false;
    }

    public boolean shouldAppearsInWindowMenu() {
        return true;
    }

    public void setDocument(XJDocument xJDocument) {
        this.document = xJDocument;
    }

    public XJDocument getDocument() {
        return this.document;
    }

    public XJData getDocumentData() {
        if (this.document != null) {
            return this.document.getDocumentData();
        }
        return null;
    }

    public void close() {
        super.close();
        XJApplication.shared().removeWindow(this);
        this.setDocument(null);
    }

    public void performClose() {
        if (this.document == null) {
            this.close();
        } else {
            this.document.performClose();
        }
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
        super.menuItemState(xJMenuItem);
        if (this.document == null) {
            if (xJMenuItem.getTag() == 10005) {
                xJMenuItem.setEnabled(true);
            } else {
                xJMenuItem.setEnabled(false);
            }
        }
        switch (xJMenuItem.getTag()) {
            case 10003: {
                xJMenuItem.setEnabled(this.document != null && this.document.isDirty());
            }
        }
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        super.handleMenuEvent(xJMenu, xJMenuItem);
        if (xJMenuItem.getTag() == 10005) {
            this.triggerClose();
        }
    }

    public void windowActivated() {
        XJMainMenuBar.refreshAllMenuBars();
        if (this.getDocument() == null) {
            return;
        }
        if (this.getDocument().isModifiedOnDisk()) {
            this.windowDocumentPathDidChange();
            this.getDocument().synchronizeLastModifiedDate();
        }
    }

    public void windowClosing() {
        this.performClose();
    }

    public void windowDocumentPathDidChange() {
    }
}

