/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.antlr.xjlib.appkit.XJControl;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.frame.XJFrameInterface;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarCustomizer;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.undo.XJUndo;
import org.antlr.xjlib.appkit.undo.XJUndoDelegate;
import org.antlr.xjlib.appkit.undo.XJUndoEngine;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJFrame
extends XJControl
implements XJFrameInterface,
XJMenuBarCustomizer,
XJMenuBarDelegate {
    private static final String PROPERTY_WINDOW_MODIFIED = "windowModified";
    private static final String PREF_DESKTOP_BOUNDS = "xjdesktop_bounds";
    private static final boolean useDesktop = XJApplication.shared().useDesktopMode();
    private static JFrame desktopFrame;
    private static JDesktopPane desktop;
    private static XJMainMenuBar desktopDefaultMenuBar;
    private JInternalFrame jInternalFrame;
    private JFrame jFrame;
    private WindowListener wl;
    private InternalFrameAdapter ifa;
    protected XJMainMenuBar mainMenuBar;
    protected XJFrameDelegate delegate;
    protected XJUndoEngine undoEngine;
    protected boolean alreadyBecomeVisible = false;
    protected boolean dirty = false;
    private String title;
    public static final String PREF_WINDOWS_BOUNDS = "xjframe_bounds";

    private static void restoreDesktopBounds() {
        Rectangle rectangle = (Rectangle)XJApplication.shared().getPreferences().getObject(PREF_DESKTOP_BOUNDS, null);
        if (rectangle != null) {
            desktopFrame.setLocation(rectangle.x, rectangle.y);
            desktopFrame.setSize(rectangle.width, rectangle.height);
        }
    }

    private static void saveDesktopBounds() {
        Point point = desktopFrame.getLocation();
        Dimension dimension = desktopFrame.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        XJPreferences xJPreferences = XJApplication.shared().getPreferences();
        xJPreferences.setObject(PREF_DESKTOP_BOUNDS, rectangle);
    }

    public static void closeDesktop() {
        if (useDesktop) {
            XJFrame.saveDesktopBounds();
        }
    }

    public XJFrame() {
        if (useDesktop) {
            if (desktopFrame == null) {
                desktopFrame = new JFrame();
                desktopFrame.setTitle(XJApplication.shared().getApplicationName());
                this.wl = new WindowAdapter(){

                    public void windowActivated(WindowEvent windowEvent) {
                        XJFrame.this.windowActivated();
                        FrameManager.frameActivated(XJFrame.this);
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        XJApplication.shared().performQuit();
                    }
                };
                desktopFrame.addWindowListener(this.wl);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                dimension = new Dimension((int)((double)dimension.width * 0.9), (int)((double)dimension.height * 0.9));
                desktopFrame.setSize(dimension);
                desktopFrame.setPreferredSize(dimension);
                desktopFrame.setLocationRelativeTo(null);
                XJFrame.restoreDesktopBounds();
                desktop = new JDesktopPane();
                desktopFrame.getContentPane().add((Component)desktop, "Center");
                desktopFrame.setVisible(true);
                new InternalFrameHandling();
            }
            this.jInternalFrame = new JInternalFrame();
            this.jInternalFrame.setResizable(true);
            this.jInternalFrame.setClosable(true);
            this.jInternalFrame.setMaximizable(true);
            this.jInternalFrame.setIconifiable(true);
            desktop.add(this.jInternalFrame);
            this.ifa = new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    XJMainMenuBar xJMainMenuBar = XJFrame.this.getMainMenuBar();
                    if (xJMainMenuBar != null) {
                        desktopFrame.setJMenuBar(xJMainMenuBar.getJMenuBar());
                    }
                    XJFrame.this.windowActivated();
                    FrameManager.frameActivated(XJFrame.this);
                }

                public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                    if (XJFrame.this.jInternalFrame != null) {
                        XJFrame.this.windowDeactivated();
                    }
                    FrameManager.frameDeactivated(XJFrame.this);
                }

                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    if (desktopFrame != null && XJFrame.this.jInternalFrame.isSelected()) {
                        desktopFrame.setJMenuBar(desktopDefaultMenuBar.getJMenuBar());
                    }
                    XJFrame.this.windowIsClosing();
                }
            };
            this.jInternalFrame.addInternalFrameListener(this.ifa);
        } else {
            this.jFrame = new JFrame();
            this.wl = new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    XJFrame.this.windowActivated();
                    FrameManager.frameActivated(XJFrame.this);
                }

                public void windowDeactivated(WindowEvent windowEvent) {
                    if (XJFrame.this.jFrame != null) {
                        XJFrame.this.windowDeactivated();
                    }
                    FrameManager.frameDeactivated(XJFrame.this);
                }

                public void windowClosing(WindowEvent windowEvent) {
                    XJFrame.this.windowIsClosing();
                }
            };
            this.jFrame.addWindowListener(this.wl);
        }
        this.setDefaultSize();
        this.undoEngine = new XJUndoEngine();
    }

    public void awake() {
        if (this.shouldDisplayMainMenuBar()) {
            this.mainMenuBar = XJMainMenuBar.createInstance();
            this.mainMenuBar.setCustomizer(this);
            this.mainMenuBar.setDelegate(this);
            this.mainMenuBar.createMenuBar();
            this.setMainMenuBar(this.mainMenuBar);
            this.undoEngine.setMainMenuBar(this.mainMenuBar);
        }
    }

    public void setDelegate(XJFrameDelegate xJFrameDelegate) {
        this.delegate = xJFrameDelegate;
    }

    public XJFrameDelegate getDelegate() {
        return this.delegate;
    }

    public void setDefaultCloseOperation(int n) {
        if (useDesktop) {
            this.jInternalFrame.setDefaultCloseOperation(n);
        } else {
            this.jFrame.setDefaultCloseOperation(n);
        }
    }

    public Container getContentPane() {
        if (useDesktop) {
            return this.jInternalFrame.getContentPane();
        }
        return this.jFrame.getContentPane();
    }

    public JRootPane getRootPane() {
        if (useDesktop) {
            return this.jInternalFrame.getRootPane();
        }
        return this.jFrame.getRootPane();
    }

    public JLayeredPane getLayeredPane() {
        if (useDesktop) {
            return this.jInternalFrame.getLayeredPane();
        }
        return this.jFrame.getLayeredPane();
    }

    public Component getGlassPane() {
        if (useDesktop) {
            return this.jInternalFrame.getGlassPane();
        }
        return this.jFrame.getGlassPane();
    }

    public void setMainMenuBar(XJMainMenuBar xJMainMenuBar) {
        this.mainMenuBar = xJMainMenuBar;
        if (useDesktop) {
            if (this.jInternalFrame.isSelected()) {
                desktopFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
            }
        } else {
            this.jFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
        }
    }

    public XJMainMenuBar getMainMenuBar() {
        return this.mainMenuBar;
    }

    public void menuItemStatusChanged(int n) {
        if (this.mainMenuBar == null) {
            return;
        }
        XJMainMenuBar.refreshAllMenuBars();
        this.mainMenuBar.refreshState();
    }

    public void setTitle(String string) {
        this.title = string;
        if (useDesktop) {
            this.jInternalFrame.setTitle(this.customizeWindowTitle(string));
        } else {
            this.jFrame.setTitle(this.customizeWindowTitle(string));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void updateTitle() {
        this.setTitle(this.title);
    }

    protected String customizeWindowTitle(String string) {
        if (this.dirty() && !XJSystem.isMacOS()) {
            return string + " [modified]";
        }
        return string;
    }

    public void setLocation(Point point) {
        if (useDesktop) {
            this.jInternalFrame.setLocation(point);
        } else {
            this.jFrame.setLocation(point);
        }
    }

    public Point getLocation() {
        if (useDesktop) {
            return this.jInternalFrame.getLocation();
        }
        return this.jFrame.getLocation();
    }

    public void setSize(int n, int n2) {
        if (useDesktop) {
            this.jInternalFrame.setSize(n, n2);
        } else {
            this.jFrame.setSize(n, n2);
        }
    }

    public void setSize(Dimension dimension) {
        if (useDesktop) {
            this.jInternalFrame.setSize(dimension);
        } else {
            this.jFrame.setSize(dimension);
        }
    }

    public Dimension getSize() {
        if (useDesktop) {
            return this.jInternalFrame.getSize();
        }
        return this.jFrame.getSize();
    }

    public void setDefaultSize() {
        if (useDesktop) {
            Dimension dimension = desktop.getSize();
            this.setSize((int)((double)dimension.width * 0.8), (int)((double)dimension.height * 0.8));
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize((int)((double)dimension.width * 0.5), (int)((double)dimension.height * 0.5));
        }
    }

    public void setResizable(boolean bl) {
        if (useDesktop) {
            this.jInternalFrame.setResizable(bl);
        } else {
            this.jFrame.setResizable(bl);
        }
    }

    public void setMaximizable(boolean bl) {
        if (useDesktop) {
            this.jInternalFrame.setMaximizable(bl);
        }
    }

    public boolean isMaximized() {
        return useDesktop && this.jInternalFrame.isMaximum();
    }

    public void pack() {
        if (useDesktop) {
            this.jInternalFrame.pack();
        } else {
            this.jFrame.pack();
        }
    }

    public void bringToFront() {
        if (useDesktop) {
            if (this.jInternalFrame == null) {
                return;
            }
            this.jInternalFrame.moveToFront();
            try {
                this.jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        } else {
            this.jFrame.toFront();
        }
    }

    public void setVisible(boolean bl) {
        if (bl && !this.alreadyBecomeVisible) {
            this.alreadyBecomeVisible = true;
            this.restoreWindowBounds();
            this.ensureVisibility();
            this.becomingVisibleForTheFirstTime();
        }
        if (useDesktop) {
            this.jInternalFrame.setVisible(bl);
        } else {
            this.jFrame.setVisible(bl);
        }
        this.bringToFront();
    }

    public void ensureVisibility() {
        if (!this.isVisibleOnScreen()) {
            this.center();
        }
    }

    public void becomingVisibleForTheFirstTime() {
    }

    public String autosaveName() {
        return null;
    }

    public boolean isVisible() {
        if (useDesktop) {
            return this.jInternalFrame.isVisible();
        }
        return this.jFrame.isVisible();
    }

    public boolean isActive() {
        if (useDesktop) {
            return this.jInternalFrame.isSelected();
        }
        return this.jFrame.isActive();
    }

    public void show() {
        this.setVisible(true);
    }

    public void showModal() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void triggerClose() {
        if (FrameManager.activated != null && FrameManager.activated != this) {
            FrameManager.activated.triggerClose();
        } else if (useDesktop) {
            try {
                this.jInternalFrame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        } else {
            this.windowIsClosing();
        }
    }

    private void windowIsClosing() {
        this.windowClosing();
        FrameManager.removeFrame(this);
    }

    public boolean isCompletelyOnScreen() {
        return this.isVisibleOnScreen();
    }

    public boolean isVisibleOnScreen() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = useDesktop ? this.jInternalFrame.getBounds() : this.jFrame.getBounds();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            if (!rectangle.intersects(graphicsConfiguration.getBounds())) continue;
            return true;
        }
        return false;
    }

    public void center() {
        if (useDesktop) {
            Dimension dimension = desktopFrame.getSize();
            Dimension dimension2 = this.jInternalFrame.getSize();
            this.jInternalFrame.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        } else {
            this.jFrame.setLocationRelativeTo(null);
        }
    }

    public void setPosition(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public void offsetPosition(int n, int n2) {
        Point point = this.getLocation();
        this.setPosition(point.x + n, point.y + n2);
    }

    public void close() {
        XJMainMenuBar.removeInstance(this.mainMenuBar);
        if (this.mainMenuBar != null) {
            this.mainMenuBar.setCustomizer(null);
            this.mainMenuBar.setDelegate(null);
            this.mainMenuBar = null;
        }
        this.saveWindowBounds();
        if (useDesktop) {
            desktopFrame.removeWindowListener(this.wl);
            this.jInternalFrame.removeInternalFrameListener(this.ifa);
            this.jInternalFrame.dispose();
            desktop.remove(this.jInternalFrame);
            this.jInternalFrame = null;
        } else {
            this.jFrame.removeWindowListener(this.wl);
            this.jFrame.dispose();
            this.jFrame = null;
        }
        if (this.delegate != null) {
            this.delegate.frameDidClose(this);
        }
    }

    public void setDirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return;
        }
        if (!this.dirty) {
            this.dirty = true;
            this.getRootPane().putClientProperty(PROPERTY_WINDOW_MODIFIED, Boolean.TRUE);
            this.menuItemStatusChanged(10003);
            this.updateTitle();
        }
    }

    public void resetDirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return;
        }
        if (this.dirty) {
            this.dirty = false;
            this.getRootPane().putClientProperty(PROPERTY_WINDOW_MODIFIED, Boolean.FALSE);
            this.menuItemStatusChanged(10003);
            this.updateTitle();
        }
    }

    public boolean dirty() {
        if (!XJApplication.shared().supportsPersistence()) {
            return false;
        }
        Boolean bl = (Boolean)this.getRootPane().getClientProperty(PROPERTY_WINDOW_MODIFIED);
        return bl != null && bl != false;
    }

    public void registerUndo(XJUndoDelegate xJUndoDelegate, JTextPane jTextPane) {
        this.undoEngine.registerUndo(new XJUndo(this.undoEngine, xJUndoDelegate), jTextPane);
    }

    public void unregisterUndo(XJUndoDelegate xJUndoDelegate) {
        this.undoEngine.unregisterUndo(xJUndoDelegate);
    }

    public void performUndo() {
        XJUndo xJUndo = this.getCurrentUndo();
        if (xJUndo != null) {
            xJUndo.performUndo();
        }
    }

    public void performRedo() {
        XJUndo xJUndo = this.getCurrentUndo();
        if (xJUndo != null) {
            xJUndo.performRedo();
        }
    }

    public XJUndo getUndo(JTextPane jTextPane) {
        return this.undoEngine.getUndo(jTextPane);
    }

    public XJUndo getCurrentUndo() {
        return this.undoEngine.getCurrentUndo();
    }

    public boolean shouldDisplayMainMenuBar() {
        return true;
    }

    public boolean shouldAppearsInWindowMenu() {
        return false;
    }

    public void windowActivated() {
    }

    public void windowDeactivated() {
    }

    public void windowClosing() {
    }

    public void customizeFileMenu(XJMenu xJMenu) {
    }

    public void customizeEditMenu(XJMenu xJMenu) {
    }

    public void customizeWindowMenu(XJMenu xJMenu) {
    }

    public void customizeHelpMenu(XJMenu xJMenu) {
    }

    public void customizeMenuBar(XJMainMenuBar xJMainMenuBar) {
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
        switch (xJMenuItem.getTag()) {
            case 10000: {
                xJMenuItem.setTitle(XJLocalizable.getXJString("New") + (XJApplication.shared().getDocumentExtensions().size() > 1 ? "..." : ""));
                break;
            }
            case 10023: 
            case 10024: {
                this.getMainMenuBar().menuUndoRedoItemState(this.undoEngine.getCurrentUndo());
            }
        }
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        switch (xJMenuItem.getTag()) {
            case 10023: {
                this.performUndo();
                break;
            }
            case 10024: {
                this.performRedo();
                break;
            }
            case 10025: {
                XJFrame.performActionOnFocusedJComponent("cut-to-clipboard");
                break;
            }
            case 10026: {
                XJFrame.performActionOnFocusedJComponent("copy-to-clipboard");
                break;
            }
            case 10027: {
                XJFrame.performActionOnFocusedJComponent("paste-from-clipboard");
                break;
            }
            case 10028: {
                XJFrame.performActionOnFocusedJComponent("select-all");
            }
        }
    }

    public void handleMenuSelected(XJMenu xJMenu) {
    }

    public static void performActionOnFocusedJComponent(String string) {
        JComponent jComponent = XJFrame.getFocusedJComponent();
        if (jComponent != null) {
            jComponent.getActionMap().get(string).actionPerformed(null);
        }
    }

    public static JComponent getFocusedJComponent() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (component instanceof JComponent) {
            return (JComponent)component;
        }
        return null;
    }

    public Container getJavaContainer() {
        if (useDesktop) {
            return this.jInternalFrame;
        }
        return this.jFrame;
    }

    private void restoreWindowBounds() {
        String string = this.autosaveName();
        if (string == null) {
            return;
        }
        Rectangle rectangle = this.restoreWindowBoundsNewWay(string);
        if (rectangle == null) {
            rectangle = (Rectangle)XJApplication.shared().getPreferences().getObject(string, null);
        }
        if (rectangle != null) {
            this.setPosition(rectangle.x, rectangle.y);
            this.setSize(rectangle.width, rectangle.height);
        }
    }

    private Rectangle restoreWindowBoundsNewWay(String string) {
        Map map = (Map)XJApplication.shared().getPreferences().getObject(PREF_WINDOWS_BOUNDS, null);
        if (map == null) {
            return null;
        }
        return (Rectangle)map.get(string);
    }

    protected void saveWindowBounds() {
        String string = this.autosaveName();
        if (string == null) {
            return;
        }
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        XJPreferences xJPreferences = XJApplication.shared().getPreferences();
        HashMap<String, Rectangle> hashMap = (HashMap<String, Rectangle>)xJPreferences.getObject(PREF_WINDOWS_BOUNDS, null);
        if (hashMap == null) {
            hashMap = new HashMap<String, Rectangle>();
        }
        hashMap.put(string, rectangle);
        xJPreferences.setObject(PREF_WINDOWS_BOUNDS, hashMap);
    }

    private static class FrameManager {
        private static List<XJFrame> frames = new ArrayList<XJFrame>();
        private static XJFrame activated = null;

        private FrameManager() {
        }

        public static void removeFrame(XJFrame xJFrame) {
            frames.remove(xJFrame);
            if (activated == xJFrame) {
                activated = null;
            }
        }

        public static void frameActivated(XJFrame xJFrame) {
            frames.remove(xJFrame);
            frames.add(xJFrame);
            activated = xJFrame;
        }

        public static void frameDeactivated(final XJFrame xJFrame) {
            int n;
            if (activated == xJFrame) {
                activated = null;
            }
            if ((n = frames.indexOf(xJFrame)) == -1) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FrameManager.selectNextFrame(xJFrame);
                }
            });
        }

        public static XJFrame getNextFrame(XJFrame xJFrame) {
            for (int i = frames.size() - 1; i >= 0; --i) {
                if (frames.get(i).equals(xJFrame)) continue;
                return frames.get(i);
            }
            return null;
        }

        public static void selectNextFrame(XJFrame xJFrame) {
            if (XJSystem.isMacOS()) {
                return;
            }
            if (activated == xJFrame) {
                return;
            }
            XJFrame xJFrame2 = FrameManager.getNextFrame(xJFrame);
            if (xJFrame2 != null) {
                xJFrame2.bringToFront();
            } else if (frames.isEmpty() || frames.size() == 1 && frames.get(0).equals(xJFrame) && desktopFrame != null) {
                desktopFrame.setJMenuBar(desktopDefaultMenuBar.getJMenuBar());
                desktopFrame.toFront();
            }
        }
    }

    private static class InternalFrameHandling
    implements XJMenuBarDelegate {
        public InternalFrameHandling() {
            desktopDefaultMenuBar = XJMainMenuBar.createInstance();
            desktopDefaultMenuBar.createMenuBar();
            desktopDefaultMenuBar.setDelegate(this);
            desktopDefaultMenuBar.refreshState();
        }

        public void menuItemState(XJMenuItem xJMenuItem) {
            int n = xJMenuItem.getTag();
            switch (n) {
                case 10000: {
                    xJMenuItem.setTitle(XJLocalizable.getXJString("New") + (XJApplication.shared().getDocumentExtensions().size() > 1 ? "..." : ""));
                }
                case 10001: 
                case 20000: 
                case 20001: {
                    xJMenuItem.setEnabled(true);
                    break;
                }
                default: {
                    if (XJMainMenuBar.isRecentFilesItem(xJMenuItem)) {
                        xJMenuItem.setEnabled(true);
                        break;
                    }
                    xJMenuItem.setEnabled(false);
                }
            }
        }

        public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
        }

        public void handleMenuSelected(XJMenu xJMenu) {
        }
    }
}

