/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.frame;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.antlr.xjlib.appkit.XJControl;
import org.antlr.xjlib.appkit.app.XJApplication;

public class XJDialog
extends XJControl {
    public static final int BUTTON_CANCEL = 0;
    public static final int BUTTON_OK = 1;
    protected JDialog jDialog = null;
    protected JButton defaultButton = null;
    protected int returnCode = 0;
    protected Container parent;

    public static Container resolveOwner(Container container) {
        Container container2;
        Container container3 = container2 = container == null ? XJApplication.getActiveContainer() : container;
        if (container instanceof Dialog || container instanceof Frame) {
            return container2;
        }
        if (container != null) {
            return SwingUtilities.getWindowAncestor(container);
        }
        return null;
    }

    public XJDialog(Container container, boolean bl) {
        this.parent = XJDialog.resolveOwner(container);
        this.jDialog = this.parent instanceof Dialog ? new JDialog((Dialog)this.parent) : (this.parent instanceof Frame ? new JDialog((Frame)this.parent) : new JDialog());
        this.jDialog.setModal(bl);
        this.jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                XJDialog.this.dialogWillCloseCancel();
            }
        });
        this.addEscapeHandling();
        this.setDefaultSize();
    }

    public void setDefaultCloseOperation(int n) {
        this.jDialog.setDefaultCloseOperation(n);
    }

    public Container getContentPane() {
        return this.jDialog.getContentPane();
    }

    public void setTitle(String string) {
        this.jDialog.setTitle(string);
    }

    public String getTitle() {
        return this.jDialog.getTitle();
    }

    public void setSize(int n, int n2) {
        this.jDialog.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.jDialog.setSize(dimension);
    }

    public Dimension getSize() {
        return this.jDialog.getSize();
    }

    public void setDefaultSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.jDialog.setSize((int)((double)dimension.width * 0.5), (int)((double)dimension.height * 0.5));
    }

    public void setResizable(boolean bl) {
        this.jDialog.setResizable(bl);
    }

    public void setDefaultButton(JButton jButton) {
        this.defaultButton = jButton;
    }

    public void setOKButton(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (XJDialog.this.dialogCanCloseOK()) {
                    XJDialog.this.dialogWillCloseOK();
                    XJDialog.this.closeWithReturnCode(1);
                }
            }
        });
    }

    public void setCancelButton(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XJDialog.this.dialogWillCloseCancel();
                XJDialog.this.closeWithReturnCode(0);
            }
        });
    }

    public void addEscapeHandling() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                XJDialog.this.closeWithReturnCode(0);
            }
        };
        this.jDialog.getRootPane().registerKeyboardAction(abstractAction, "CancelAction", keyStroke, 2);
    }

    public void setReturnCode(int n) {
        this.returnCode = n;
    }

    public void bringToFront() {
        this.jDialog.toFront();
    }

    public void center() {
        this.jDialog.setLocationRelativeTo(this.parent);
    }

    public void setPosition(int n, int n2) {
        this.jDialog.setLocation(n, n2);
    }

    public void setPosition(Point point) {
        this.jDialog.setLocation(point);
    }

    public Point getPosition() {
        return this.jDialog.getLocation();
    }

    public void offsetPosition(int n, int n2) {
        Point point = this.jDialog.getLocation();
        this.jDialog.setLocation(point.x + n, point.y + n2);
    }

    public Component getJavaComponent() {
        return this.jDialog;
    }

    public void closeWithReturnCode(int n) {
        this.setReturnCode(n);
        this.close();
    }

    public void close() {
        this.jDialog.dispose();
    }

    public void pack() {
    }

    public boolean dialogCanCloseOK() {
        return true;
    }

    public void dialogWillDisplay() {
    }

    public void dialogWillCloseCancel() {
    }

    public void dialogWillCloseOK() {
    }

    public void setVisible(boolean bl) {
        this.jDialog.setVisible(bl);
    }

    public void display() {
        this.center();
        this.jDialog.setVisible(true);
    }

    public int runModal() {
        this.center();
        this.dialogWillDisplay();
        if (this.defaultButton != null) {
            this.jDialog.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.jDialog.setVisible(true);
        return this.returnCode;
    }
}

