/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.document;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.document.XJData;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJObject;
import org.antlr.xjlib.foundation.XJUtils;

public class XJDocument
extends XJObject {
    protected XJData documentData = null;
    protected XJWindow documentWindow = null;
    protected String documentTitle = XJLocalizable.getXJString("DocUntitled");
    protected String documentPath = null;
    protected List documentFileExts = null;
    protected String documentFileExtDescription = null;
    protected boolean dirty = false;
    protected boolean firstDocument = false;
    protected boolean writing = false;
    protected Component javaContainer = null;
    protected static int absoluteCounter = 0;
    protected long lastModifiedOnDisk = 0L;

    public XJDocument() {
        XJApplication.shared().addDocument(this);
        this.firstDocument = absoluteCounter == 0;
        ++absoluteCounter;
    }

    public boolean isFirstDocument() {
        return this.firstDocument;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void changeDone() {
        if (this.dirty) {
            return;
        }
        this.dirty = true;
        if (this.documentWindow != null) {
            this.documentWindow.setDirty();
        }
    }

    public void changeReset() {
        this.dirty = false;
        if (this.documentWindow != null) {
            this.documentWindow.resetDirty();
        }
    }

    public void setTitle(String string) {
        this.documentTitle = string;
        if (this.documentWindow != null) {
            this.documentWindow.setTitle(this.documentTitle);
        }
    }

    public void setWindow(XJWindow xJWindow) {
        this.documentWindow = xJWindow;
        if (this.documentWindow != null) {
            this.documentWindow.setDocument(this);
            this.documentWindow.setTitle(this.documentTitle);
        }
    }

    public XJWindow getWindow() {
        return this.documentWindow;
    }

    public void setJavaContainer(Component component) {
        this.javaContainer = component;
    }

    public Component getJavaContainer() {
        if (this.javaContainer == null) {
            return this.getWindow() == null ? null : this.getWindow().getJavaContainer();
        }
        return this.javaContainer;
    }

    public void showWindow() {
        if (this.documentWindow != null) {
            this.documentWindow.show();
        }
    }

    public void setDocumentData(XJData xJData) {
        this.documentData = xJData;
        if (this.documentData != null) {
            this.documentData.addObserver(this);
        }
    }

    public XJData getDocumentData() {
        return this.documentData;
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public String getDocumentName() {
        return XJUtils.getLastPathComponent(this.documentPath);
    }

    public void setDocumentFileType(List list, String string) {
        this.documentFileExts = list;
        this.documentFileExtDescription = string;
    }

    public void observeValueForKey(Object object, String string, Object object2) {
        if (!this.writing) {
            this.changeDone();
        }
    }

    public long getDateOfModificationOnDisk() {
        if (this.getDocumentPath() == null) {
            return 0L;
        }
        File file = null;
        try {
            file = new File(this.getDocumentPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            return 0L;
        }
        return file.lastModified();
    }

    public void synchronizeLastModifiedDate() {
        this.lastModifiedOnDisk = this.getDateOfModificationOnDisk();
    }

    public boolean isModifiedOnDisk() {
        return this.lastModifiedOnDisk != this.getDateOfModificationOnDisk();
    }

    private boolean performLoad_() {
        if (!this.dirty) {
            return true;
        }
        int n = XJAlert.displayAlertYESNOCANCEL(this.getJavaContainer(), XJLocalizable.getXJString("DocLoad"), XJLocalizable.getStringFormat("DocSaveChanges", this.documentTitle));
        switch (n) {
            case 0: {
                return this.performSave(false);
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    public boolean performLoad(String string) {
        this.documentPath = string;
        try {
            this.readDocument(this.documentPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XJAlert.display(this.getJavaContainer(), XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocLoadError") + " " + exception.toString());
            return false;
        }
        this.setTitle(this.documentPath);
        this.changeReset();
        return true;
    }

    public boolean performLoad() {
        if (!this.performLoad_()) {
            return false;
        }
        if (!XJFileChooser.shared().displayOpenDialog(this.getJavaContainer(), this.documentFileExts, this.documentFileExtDescription, false)) {
            return false;
        }
        String string = XJFileChooser.shared().getSelectedFilePath();
        XJDocument xJDocument = XJApplication.shared().getDocumentForPath(string);
        if (xJDocument != null && xJDocument != this) {
            XJAlert.display(this.getJavaContainer(), XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocLoadExists"));
            return false;
        }
        XJApplication.shared().addRecentFile(string);
        return this.performLoad(XJFileChooser.shared().getSelectedFilePath());
    }

    public boolean reload() {
        try {
            this.readDocument(this.documentPath);
        }
        catch (Exception exception) {
            XJAlert.display(this.getJavaContainer(), XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocLoadError") + " " + exception.toString());
            return false;
        }
        return true;
    }

    public boolean performAutoSave() {
        return this.getDocumentPath() == null || !this.isDirty() || this.performSave(false);
    }

    public boolean performSave(boolean bl) {
        if (this.documentPath == null || bl) {
            if (!XJFileChooser.shared().displaySaveDialog(this.getJavaContainer(), this.documentFileExts, this.documentFileExtDescription, true)) {
                return false;
            }
            this.documentPath = XJFileChooser.shared().getSelectedFilePath();
            XJApplication.shared().addRecentFile(this.documentPath);
        }
        try {
            this.writeDocument(this.documentPath);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XJAlert.display(this.getJavaContainer(), XJLocalizable.getXJString("DocError"), XJLocalizable.getXJString("DocSaveError") + " " + exception.toString());
            return false;
        }
        this.setTitle(this.documentPath);
        this.changeReset();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performClose_() {
        if (!this.dirty) return true;
        if (!XJApplication.shared().supportsPersistence()) {
            return true;
        }
        if (this.documentWindow != null) {
            this.documentWindow.bringToFront();
        }
        XJAlert.disableEscapeKey();
        try {
            int n = XJAlert.displayAlertYESNOCANCEL(this.getJavaContainer(), XJLocalizable.getXJString("DocCloseTitle"), XJLocalizable.getStringFormat("DocCloseMessage", this.documentTitle));
            switch (n) {
                case 0: {
                    boolean bl = this.performSave(false);
                    return bl;
                }
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        finally {
            XJAlert.enableEscapeKey();
        }
    }

    public boolean performClose(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl ? true : this.performClose_();
        if (bl2) {
            XJApplication.shared().addRecentFile(this.getDocumentPath());
            XJApplication.shared().removeDocument(this);
            if (this.documentWindow != null) {
                this.documentWindow.close();
                this.documentWindow = null;
            }
        }
        return bl2;
    }

    public boolean performClose() {
        return this.performClose(false);
    }

    private void beginWrite() {
        this.writing = true;
    }

    private void endWrite() {
        this.writing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(String string) throws IOException {
        this.beginWrite();
        try {
            this.documentWillWriteData();
            this.documentData.setFile(string);
            switch (this.documentData.dataType()) {
                case 1: {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    this.documentData.writeData(fileOutputStream);
                    ((OutputStream)fileOutputStream).close();
                    break;
                }
                case 2: {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    this.documentData.writeData(new ObjectOutputStream(fileOutputStream));
                    ((OutputStream)fileOutputStream).close();
                    break;
                }
                case 3: {
                    this.documentData.writeData();
                    break;
                }
                case 4: {
                    this.documentData.writeData();
                }
            }
            this.synchronizeLastModifiedDate();
        }
        finally {
            this.endWrite();
        }
    }

    private void readDocument(String string) throws IOException, ClassNotFoundException {
        this.documentWillReadData();
        this.documentData.setFile(string);
        switch (this.documentData.dataType()) {
            case 1: {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.documentData.readData(fileInputStream);
                ((InputStream)fileInputStream).close();
                break;
            }
            case 2: {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.documentData.readData(new ObjectInputStream(fileInputStream));
                ((InputStream)fileInputStream).close();
                break;
            }
            case 3: {
                this.documentData.readData();
                break;
            }
            case 4: {
                this.documentData.readData();
            }
        }
        this.documentDidReadData();
        this.synchronizeLastModifiedDate();
    }

    public void documentWillWriteData() {
    }

    public void documentWillReadData() {
    }

    public void documentDidReadData() {
    }
}

