/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.xjlib.appkit.swing.XJColorChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJPreferences {
    protected Preferences prefs = null;
    protected Map<String, EventListener> bindings = new HashMap<String, EventListener>();

    public XJPreferences(Class clazz) {
        this.prefs = Preferences.userNodeForPackage(clazz);
    }

    public void flush() {
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void setString(String string, String string2) {
        this.prefs.put(string, string2);
    }

    public String getString(String string, String string2) {
        return this.prefs.get(string, string2);
    }

    public void setInt(String string, int n) {
        this.prefs.putInt(string, n);
    }

    public void setInt(String string, Integer n) {
        this.prefs.putInt(string, n);
    }

    public int getInt(String string, int n) {
        return this.prefs.getInt(string, n);
    }

    public void setBoolean(String string, boolean bl) {
        this.prefs.putBoolean(string, bl);
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.prefs.getBoolean(string, bl);
    }

    public void setColor(String string, Color color) {
        this.setObject(string, color);
    }

    public Color getColor(String string, Color color) {
        return (Color)this.getObject(string, color);
    }

    public void setList(String string, List<String> list) {
        this.setObject(string, list);
    }

    public List<String> getList(String string) {
        return (List)this.getObject(string, null);
    }

    public void setObject(String string, Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            this.prefs.putByteArray(string, byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            System.err.println("Cannot set the object associated with key " + string + ": " + exception);
        }
    }

    public Object getObject(String string, Object object) {
        try {
            byte[] byArray = this.prefs.getByteArray(string, null);
            if (byArray == null) {
                return object;
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            return object2;
        }
        catch (Exception exception) {
            System.err.println("Cannot get the object associated with key " + string + ": " + exception);
            return object;
        }
    }

    public void remove(String string) {
        this.prefs.remove(string);
    }

    public Preferences getPreferences() {
        return this.prefs;
    }

    public void bindToPreferences(JComboBox jComboBox, String string, int n) {
        try {
            jComboBox.setSelectedIndex(this.getInt(string, n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        this.setInt(string, jComboBox.getSelectedIndex());
        JComboBoxBindingAction jComboBoxBindingAction = new JComboBoxBindingAction(jComboBox, string, true);
        this.bindings.put(string, jComboBoxBindingAction);
        jComboBox.addActionListener(jComboBoxBindingAction);
    }

    public void bindToPreferences(JComboBox jComboBox, String string, String string2) {
        jComboBox.setSelectedItem(this.getString(string, string2));
        this.setString(string, (String)jComboBox.getSelectedItem());
        JComboBoxBindingAction jComboBoxBindingAction = new JComboBoxBindingAction(jComboBox, string, false);
        this.bindings.put(string, jComboBoxBindingAction);
        jComboBox.addActionListener(jComboBoxBindingAction);
    }

    public void bindToPreferences(JSpinner jSpinner, String string, int n) {
        jSpinner.setValue(this.getInt(string, n));
        this.setInt(string, (Integer)jSpinner.getValue());
        JSpinnerBindingAction jSpinnerBindingAction = new JSpinnerBindingAction(jSpinner, string);
        this.bindings.put(string, jSpinnerBindingAction);
        jSpinner.addChangeListener(jSpinnerBindingAction);
    }

    public void bindToPreferences(JTextField jTextField, String string, int n) {
        this.bindToPreferences(jTextField, string, String.valueOf(n));
    }

    public void bindToPreferences(JTextField jTextField, String string, String string2) {
        jTextField.setText(this.getString(string, string2));
        this.setString(string, jTextField.getText());
        JTextFieldBindingAction jTextFieldBindingAction = new JTextFieldBindingAction(jTextField, string);
        this.bindings.put(string, jTextFieldBindingAction);
        jTextField.addActionListener(jTextFieldBindingAction);
    }

    public void defaultPreference(JCheckBox jCheckBox, String string, boolean bl) {
        jCheckBox.setSelected(bl);
        this.setBoolean(string, jCheckBox.isSelected());
    }

    public void bindToPreferences(JCheckBox jCheckBox, String string, boolean bl) {
        jCheckBox.setSelected(this.getBoolean(string, bl));
        this.setBoolean(string, jCheckBox.isSelected());
        JCheckBoxBindingAction jCheckBoxBindingAction = new JCheckBoxBindingAction(jCheckBox, string);
        this.bindings.put(string, jCheckBoxBindingAction);
        jCheckBox.addActionListener(jCheckBoxBindingAction);
    }

    public void unbindFromPreferences(JCheckBox jCheckBox, String string) {
        ActionListener actionListener = (ActionListener)this.bindings.remove(string);
        if (actionListener != null) {
            jCheckBox.removeActionListener(actionListener);
        }
    }

    public void bindToPreferences(JToggleButton jToggleButton, String string, boolean bl) {
        jToggleButton.setSelected(this.getBoolean(string, bl));
        this.setBoolean(string, jToggleButton.isSelected());
        JToggleButtonBindingAction jToggleButtonBindingAction = new JToggleButtonBindingAction(jToggleButton, string);
        this.bindings.put(string, jToggleButtonBindingAction);
        jToggleButton.addActionListener(jToggleButtonBindingAction);
    }

    public void unbindFromPreferences(JToggleButton jToggleButton, String string) {
        ActionListener actionListener = (ActionListener)this.bindings.remove(string);
        if (actionListener != null) {
            jToggleButton.removeActionListener(actionListener);
        }
    }

    public void bindToPreferences(ButtonGroup buttonGroup, String string, String string2) {
        buttonGroup.setSelected(this.getButtonWithActionCommand(buttonGroup, this.getString(string, string2)).getModel(), true);
        this.setString(string, buttonGroup.getSelection().getActionCommand());
        ButtonGroupBindingAction buttonGroupBindingAction = new ButtonGroupBindingAction(buttonGroup, string);
        this.bindings.put(string, buttonGroupBindingAction);
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.addActionListener(buttonGroupBindingAction);
        }
    }

    public void defaultPreference(JPanel jPanel, String string, Color color) {
        jPanel.setBackground(color);
        this.setColor(string, jPanel.getBackground());
    }

    public void bindToPreferences(JPanel jPanel, String string, Color color) {
        jPanel.setBackground(this.getColor(string, color));
        this.setColor(string, jPanel.getBackground());
        ColorChooserBindingMouseListener colorChooserBindingMouseListener = new ColorChooserBindingMouseListener(jPanel, string);
        this.bindings.put(string, colorChooserBindingMouseListener);
        jPanel.addMouseListener(colorChooserBindingMouseListener);
    }

    public void applyPreferences() {
        for (String string : this.bindings.keySet()) {
            this.applyPreference(string);
        }
    }

    public void applyPreference(String string) {
        EventListener eventListener = this.bindings.get(string);
        if (eventListener instanceof ActionListener) {
            ActionListener actionListener = (ActionListener)eventListener;
            actionListener.actionPerformed(null);
        } else if (eventListener instanceof ChangeListener) {
            ChangeListener changeListener = (ChangeListener)eventListener;
            changeListener.stateChanged(null);
        } else if (eventListener instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)eventListener;
            mouseListener.mousePressed(null);
        }
    }

    protected AbstractButton getButtonWithActionCommand(ButtonGroup buttonGroup, String string) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.getActionCommand().equalsIgnoreCase(string)) continue;
            return abstractButton;
        }
        return null;
    }

    protected class ColorChooserBindingMouseListener
    extends MouseAdapter {
        JPanel component = null;
        String key = null;

        public ColorChooserBindingMouseListener(JPanel jPanel, String string) {
            this.component = jPanel;
            this.key = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                XJPreferences.this.setColor(this.key, this.component.getBackground());
            } else {
                XJColorChooser xJColorChooser = new XJColorChooser(this.component.getParent(), true, this.component);
                if (xJColorChooser.runModal() == 1) {
                    XJPreferences.this.setColor(this.key, xJColorChooser.getColor());
                }
            }
        }
    }

    protected class JSpinnerBindingAction
    implements ChangeListener {
        JSpinner component = null;
        String key = null;

        public JSpinnerBindingAction(JSpinner jSpinner, String string) {
            this.component = jSpinner;
            this.key = string;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            XJPreferences.this.setInt(this.key, (Integer)this.component.getValue());
        }
    }

    protected class ButtonGroupBindingAction
    implements ActionListener {
        ButtonGroup component = null;
        String key = null;

        public ButtonGroupBindingAction(ButtonGroup buttonGroup, String string) {
            this.component = buttonGroup;
            this.key = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJPreferences.this.setString(this.key, this.component.getSelection().getActionCommand());
        }
    }

    protected class JToggleButtonBindingAction
    implements ActionListener {
        JToggleButton component = null;
        String key = null;

        public JToggleButtonBindingAction(JToggleButton jToggleButton, String string) {
            this.component = jToggleButton;
            this.key = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJPreferences.this.setBoolean(this.key, this.component.isSelected());
        }
    }

    protected class JCheckBoxBindingAction
    implements ActionListener {
        JCheckBox component = null;
        String key = null;

        public JCheckBoxBindingAction(JCheckBox jCheckBox, String string) {
            this.component = jCheckBox;
            this.key = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJPreferences.this.setBoolean(this.key, this.component.isSelected());
        }
    }

    protected class JTextFieldBindingAction
    implements ActionListener {
        JTextField component = null;
        String key = null;

        public JTextFieldBindingAction(JTextField jTextField, String string) {
            this.component = jTextField;
            this.key = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XJPreferences.this.setString(this.key, this.component.getText());
        }
    }

    protected class JComboBoxBindingAction
    implements ActionListener {
        JComboBox component = null;
        String key = null;
        boolean index = false;

        public JComboBoxBindingAction(JComboBox jComboBox, String string, boolean bl) {
            this.component = jComboBox;
            this.key = string;
            this.index = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.index) {
                XJPreferences.this.setInt(this.key, this.component.getSelectedIndex());
            } else {
                XJPreferences.this.setString(this.key, (String)this.component.getSelectedItem());
            }
        }
    }
}

