/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app;

import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.antlr.xjlib.appkit.app.XJAboutBox;
import org.antlr.xjlib.appkit.app.XJApplicationDelegate;
import org.antlr.xjlib.appkit.app.XJApplicationInterface;
import org.antlr.xjlib.appkit.app.XJPreferences;
import org.antlr.xjlib.appkit.document.XJData;
import org.antlr.xjlib.appkit.document.XJDocument;
import org.antlr.xjlib.appkit.document.XJDocumentType;
import org.antlr.xjlib.appkit.frame.XJFrame;
import org.antlr.xjlib.appkit.frame.XJFrameDelegate;
import org.antlr.xjlib.appkit.frame.XJPanel;
import org.antlr.xjlib.appkit.frame.XJWindow;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.utils.XJAlert;
import org.antlr.xjlib.appkit.utils.XJAlertInput;
import org.antlr.xjlib.appkit.utils.XJFileChooser;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJObject;
import org.antlr.xjlib.foundation.XJSystem;
import org.antlr.xjlib.foundation.timer.XJScheduledTimer;
import org.antlr.xjlib.foundation.timer.XJScheduledTimerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XJApplication
extends XJObject
implements XJApplicationInterface,
XJFrameDelegate {
    public static final boolean YES = true;
    public static final boolean NO = false;
    public static final String XJ_PREFS_RECENT_FILES = "XJ_PREFS_RECENT_FILES";
    protected static XJApplicationInterface shared = null;
    protected static XJApplicationDelegate delegate = null;
    protected static List<XJScheduledTimer> scheduledTimers = new ArrayList<XJScheduledTimer>();
    protected static final long SCHEDULED_TIMER_MINUTES = 1L;
    protected static List<XJDocument> documents = new ArrayList<XJDocument>();
    protected static List<XJWindow> windows = new ArrayList<XJWindow>();
    public static final int MAX_RECENT_FILES = 10;
    protected static List<String> recentFiles = null;
    protected static int documentAbsoluteCount = 0;
    protected static int documentAbsPositionCount = 0;
    protected static final int DOCUMENT_OFFSET_PIXELS = 20;
    protected static List<XJDocumentType> documentType = new ArrayList<XJDocumentType>();
    protected static String propertiesPath = "";
    protected static boolean startingUp = true;
    protected static String[] launchArguments = null;
    protected static List<String> documentsToOpenAtStartup = new ArrayList<String>();
    protected static String appName = "";
    protected XJPreferences userPrefs = new XJPreferences(this.getPreferencesClass());
    protected XJFrame about = null;
    protected XJPanel prefs = null;
    protected static XJScheduledTimerDelegate autoSaveTimer = null;
    private static boolean useDesktopMode;

    public static synchronized void setShared(XJApplicationInterface xJApplicationInterface) {
        shared = xJApplicationInterface;
    }

    public static synchronized XJApplicationInterface shared() {
        if (shared == null) {
            if (XJSystem.isMacOS()) {
                try {
                    shared = (XJApplication)Class.forName("org.antlr.xjlib.appkit.app.MacOS.XJApplicationMacOS").newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("XJApplication: cannot instanciate the MacOS application (" + exception + ")");
                }
            }
            if (shared == null) {
                shared = new XJApplication();
            }
            ((XJApplication)shared).startup();
        }
        return shared;
    }

    public static String getAppVersionShort() {
        return delegate.appVersionShort();
    }

    public static String getAppVersionLong() {
        return delegate.appVersionLong();
    }

    public static XJApplicationDelegate getAppDelegate() {
        return delegate;
    }

    public static Container getActiveContainer() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            if (!frame.isActive() || !frame.isVisible() || frame.getSize().width == 0 || frame.getSize().height == 0) continue;
            return frame;
        }
        return null;
    }

    public XJApplication() {
        recentFiles = this.userPrefs.getList(XJ_PREFS_RECENT_FILES);
        if (recentFiles == null) {
            recentFiles = new ArrayList<String>();
        }
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    public static void run(XJApplicationDelegate xJApplicationDelegate, String[] stringArray, String string) {
        appName = string;
        if (XJSystem.isMacOS()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        XJApplication.run(xJApplicationDelegate, stringArray);
    }

    public static void run(XJApplicationDelegate xJApplicationDelegate, String[] stringArray) {
        XJApplication.setDelegate(xJApplicationDelegate);
        launchArguments = stringArray;
        useDesktopMode = delegate.useDesktopMode();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                startingUp = false;
                delegate.appDidLaunch(launchArguments, documentsToOpenAtStartup);
                documentsToOpenAtStartup.clear();
                new Timer().schedule((TimerTask)new ScheduledTimer(), 1000L, 60000L);
            }
        });
    }

    protected void startup() {
        if (this.hasPreferencesMenuItem()) {
            this.addPreferencesMenuItem();
        } else {
            this.removePreferencesMenuItem();
        }
    }

    protected void updateRecentFilesPrefs() {
        this.userPrefs.setList(XJ_PREFS_RECENT_FILES, recentFiles);
        this.userPrefs.flush();
    }

    protected void shutdown() {
        this.updateRecentFilesPrefs();
        System.exit(0);
    }

    public static void setDelegate(XJApplicationDelegate xJApplicationDelegate) {
        delegate = xJApplicationDelegate;
    }

    public static void addScheduledTimer(XJScheduledTimerDelegate xJScheduledTimerDelegate, long l, boolean bl) {
        scheduledTimers.add(new XJScheduledTimer(xJScheduledTimerDelegate, l, bl));
    }

    public static void removeScheduledTimer(XJScheduledTimerDelegate xJScheduledTimerDelegate) {
        for (int i = scheduledTimers.size() - 1; i >= 0; --i) {
            XJScheduledTimer xJScheduledTimer = scheduledTimers.get(i);
            if (xJScheduledTimer.getDelegate() != xJScheduledTimerDelegate) continue;
            scheduledTimers.remove(xJScheduledTimer);
        }
    }

    public static void setPropertiesPath(String string) {
        propertiesPath = string;
    }

    public static String getPropertiesPath() {
        return propertiesPath;
    }

    @Override
    public String getApplicationName() {
        if (delegate != null) {
            return delegate.appName();
        }
        return "";
    }

    @Override
    public XJPreferences getPreferences() {
        return this.userPrefs;
    }

    @Override
    public void displayAbout() {
        boolean bl;
        boolean bl2 = bl = this.about == null;
        if (this.about == null) {
            this.about = delegate.appInstanciateAboutPanel();
        }
        if (this.about == null) {
            this.about = new XJAboutBox();
        }
        if (bl) {
            this.about.setDelegate(this);
            this.about.awake();
        }
        this.about.setVisible(true);
    }

    @Override
    public void displayPrefs() {
        if (this.prefs == null) {
            try {
                this.prefs = (XJPanel)delegate.appPreferencesPanelClass().newInstance();
                this.prefs.setDelegate(this);
                this.prefs.awake();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Cannot instanciate the Preferences panel: " + exception);
                return;
            }
            this.prefs.center();
        }
        this.prefs.setVisible(true);
    }

    @Override
    public void displayHelp() {
        delegate.appShowHelp();
    }

    @Override
    public void frameDidClose(XJFrame xJFrame) {
        if (xJFrame == this.prefs) {
            this.prefs = null;
        }
        if (xJFrame == this.about) {
            this.about = null;
        }
    }

    @Override
    public void addRecentFile(String string) {
        if (string == null) {
            return;
        }
        if (recentFiles.contains(string)) {
            recentFiles.remove(string);
        }
        if (recentFiles.size() > 10) {
            recentFiles.remove(recentFiles.size() - 1);
        }
        recentFiles.add(0, string);
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public void removeRecentFile(String string) {
        recentFiles.remove(string);
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public void clearRecentFiles() {
        recentFiles.clear();
        this.updateRecentFilesPrefs();
        XJMainMenuBar.refreshAllRecentFilesMenu();
    }

    @Override
    public List recentFiles() {
        return recentFiles;
    }

    protected void addPreferencesMenuItem() {
    }

    protected void removePreferencesMenuItem() {
    }

    public void refreshMainMenuBar() {
        XJMainMenuBar.refreshAllMenuBars();
    }

    public static void addDocumentType(Class clazz, Class clazz2, Class clazz3, String string, String string2) {
        documentType.add(new XJDocumentType(clazz, clazz2, clazz3, string, string2));
    }

    public static void addDocumentType(Class clazz, Class clazz2, Class clazz3, String[] stringArray, String string) {
        documentType.add(new XJDocumentType(clazz, clazz2, clazz3, stringArray, string));
    }

    public XJDocumentType getDocumentTypeForPath(String string) {
        for (XJDocumentType xJDocumentType : documentType) {
            int n = string.indexOf(".");
            if (n == -1 || !xJDocumentType.getExtensions().contains(string.substring(n + 1))) continue;
            return xJDocumentType;
        }
        return null;
    }

    public XJDocumentType getDocumentTypeForDataClass(Class clazz) {
        for (XJDocumentType xJDocumentType : documentType) {
            if (!xJDocumentType.getDataClass().equals(clazz)) continue;
            return xJDocumentType;
        }
        return null;
    }

    @Override
    public List getDocumentExtensions() {
        ArrayList<List> arrayList = new ArrayList<List>();
        for (XJDocumentType xJDocumentType : documentType) {
            arrayList.add(xJDocumentType.getExtensions());
        }
        return arrayList;
    }

    public List<String> getDocumentDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (XJDocumentType xJDocumentType : documentType) {
            arrayList.add(xJDocumentType.getDescriptionString());
        }
        return arrayList;
    }

    @Override
    public List<XJDocument> getDocuments() {
        return documents;
    }

    public XJDocumentType askForDocumentType() {
        if (documentType.size() == 1) {
            return documentType.get(0);
        }
        int n = XJAlertInput.showInputDialog(null, XJLocalizable.getXJString("AppNewDocTitle"), XJLocalizable.getXJString("AppNewDocMessage"), this.getDocumentDescriptions(), this.getDocumentDescriptions().get(0));
        if (n == -1) {
            return null;
        }
        return documentType.get(n);
    }

    public XJDocument newDocument(boolean bl, XJDocumentType xJDocumentType) {
        XJDocument xJDocument;
        if (documentType.size() == 0) {
            XJAlert.display(null, XJLocalizable.getXJString("AppNewDocErrTitle"), XJLocalizable.getXJString("AppNewDocErrMessage"));
            return null;
        }
        if (xJDocumentType == null && (xJDocumentType = this.askForDocumentType()) == null) {
            return null;
        }
        try {
            xJDocument = (XJDocument)xJDocumentType.getDocumentClass().newInstance();
            xJDocument.setDocumentData((XJData)xJDocumentType.getDataClass().newInstance());
            XJWindow xJWindow = (XJWindow)xJDocumentType.getWindowClass().newInstance();
            xJDocument.setWindow(xJWindow);
            xJWindow.awake();
            xJDocument.awake();
            xJDocument.setDocumentFileType(xJDocumentType.getExtensions(), xJDocumentType.getDescriptionString());
            if (this.supportsPersistence()) {
                xJDocument.setTitle(XJLocalizable.getXJString("AppUntitled") + " " + documentAbsoluteCount);
            } else {
                xJDocument.setTitle(documentAbsoluteCount > 0 ? appName + " " + documentAbsoluteCount : appName);
            }
            if (!xJWindow.isMaximized() && this.useDesktopMode()) {
                ++documentAbsoluteCount;
                xJDocument.getWindow().offsetPosition(documentAbsPositionCount * 20, documentAbsPositionCount * 20);
                documentAbsPositionCount = xJDocument.getWindow().isCompletelyOnScreen() ? ++documentAbsPositionCount : 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            XJAlert.display(null, XJLocalizable.getXJString("AppNewDocError"), exception.toString());
            return null;
        }
        if (bl) {
            xJDocument.showWindow();
        }
        return xJDocument;
    }

    @Override
    public XJDocument newDocumentOfData(Class clazz) {
        return this.newDocument(true, this.getDocumentTypeForDataClass(clazz));
    }

    @Override
    public XJDocument newDocument() {
        return this.newDocument(true, null);
    }

    @Override
    public boolean openDocuments(List<String> list) {
        boolean bl = true;
        for (String string : list) {
            if (this.openDocument(string)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean openDocument(String string) {
        if (string == null) {
            return false;
        }
        if (startingUp) {
            documentsToOpenAtStartup.add(string);
            return true;
        }
        XJDocument xJDocument = this.getDocumentForPath(string);
        if (xJDocument != null) {
            xJDocument.getWindow().bringToFront();
            return true;
        }
        xJDocument = this.newDocument(false, this.getDocumentTypeForPath(string));
        if (xJDocument == null) {
            return false;
        }
        if (xJDocument.performLoad(string)) {
            this.addRecentFile(string);
            xJDocument.showWindow();
            this.closeFirstCreatedWindowIfNonDirty();
            return true;
        }
        xJDocument.performClose(true);
        return false;
    }

    @Override
    public boolean openDocument() {
        return XJFileChooser.shared().displayOpenDialog(null, this.getDocumentExtensions(), this.getDocumentDescriptions(), false) && this.openDocument(XJFileChooser.shared().getSelectedFilePath());
    }

    @Override
    public boolean openLastUsedDocument() {
        if (recentFiles.isEmpty()) {
            return false;
        }
        String string = recentFiles.get(0);
        while (!new File(string).exists()) {
            recentFiles.remove(0);
            if (recentFiles.isEmpty()) {
                this.updateRecentFilesPrefs();
                return false;
            }
            string = recentFiles.get(0);
        }
        this.updateRecentFilesPrefs();
        if (this.openDocument(string)) {
            return true;
        }
        this.removeRecentFile(string);
        return false;
    }

    @Override
    public void addDocument(XJDocument xJDocument) {
        documents.add(xJDocument);
    }

    @Override
    public void removeDocument(XJDocument xJDocument) {
        documents.remove(xJDocument);
    }

    public void closeFirstCreatedWindowIfNonDirty() {
        for (XJDocument xJDocument : documents) {
            if (!xJDocument.isFirstDocument() || xJDocument.isDirty() || xJDocument.getDocumentPath() != null) continue;
            xJDocument.performClose();
            break;
        }
    }

    @Override
    public XJDocument getActiveDocument() {
        for (XJDocument xJDocument : documents) {
            if (xJDocument.getWindow() == null || !xJDocument.getWindow().isActive()) continue;
            return xJDocument;
        }
        return null;
    }

    @Override
    public XJDocument getDocumentForPath(String string) {
        for (XJDocument xJDocument : documents) {
            String string2 = xJDocument.getDocumentPath();
            if (string2 == null || !string2.equals(string)) continue;
            return xJDocument;
        }
        return null;
    }

    @Override
    public XJWindow getActiveWindow() {
        for (XJWindow xJWindow : windows) {
            if (!xJWindow.isActive()) continue;
            return xJWindow;
        }
        return null;
    }

    @Override
    public void addWindow(XJWindow xJWindow) {
        windows.add(xJWindow);
    }

    public int getNumberOfNonAuxiliaryWindows() {
        int n = 0;
        for (XJWindow xJWindow : windows) {
            if (xJWindow.isAuxiliaryWindow()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void removeWindow(XJWindow xJWindow) {
        windows.remove(xJWindow);
        this.refreshMainMenuBar();
        if (this.getNumberOfNonAuxiliaryWindows() == 0 && !startingUp && (!XJSystem.isMacOS() && !this.useDesktopMode() || this.shouldQuitAfterLastWindowClosed())) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    XJApplication.this.performQuit();
                }
            });
        }
    }

    @Override
    public List<XJWindow> getWindows() {
        return windows;
    }

    @Override
    public List<XJWindow> getWindowsInWindowMenu() {
        ArrayList<XJWindow> arrayList = new ArrayList<XJWindow>();
        for (XJWindow xJWindow : windows) {
            if (!xJWindow.shouldAppearsInWindowMenu()) continue;
            arrayList.add(xJWindow);
        }
        return arrayList;
    }

    public static void setAutoSave(boolean bl, int n) {
        if (autoSaveTimer == null) {
            autoSaveTimer = new AutoSaveTimer();
        }
        XJApplication.removeScheduledTimer(autoSaveTimer);
        if (bl) {
            XJApplication.addScheduledTimer(autoSaveTimer, n, false);
        }
    }

    public void performPreferences() {
        this.displayPrefs();
    }

    @Override
    public void performQuit() {
        delegate.appWillTerminate();
        Iterator<XJDocument> iterator = documents.iterator();
        while (iterator.hasNext()) {
            XJDocument xJDocument = iterator.next();
            if (xJDocument.performClose()) {
                iterator = documents.iterator();
                continue;
            }
            return;
        }
        XJFrame.closeDesktop();
        this.shutdown();
    }

    @Override
    public boolean supportsPersistence() {
        return delegate == null || delegate.supportsPersistence();
    }

    @Override
    public boolean hasPreferencesMenuItem() {
        return delegate == null || delegate.appHasPreferencesMenuItem();
    }

    public boolean shouldQuitAfterLastWindowClosed() {
        return delegate != null && delegate.appShouldQuitAfterLastWindowClosed();
    }

    @Override
    public boolean useDesktopMode() {
        return useDesktopMode;
    }

    public Class getPreferencesClass() {
        if (delegate == null) {
            return XJApplication.class;
        }
        return delegate.appPreferencesClass();
    }

    public static class AutoSaveTimer
    implements XJScheduledTimerDelegate {
        public void scheduledTimerFired(boolean bl) {
            for (XJDocument xJDocument : documents) {
                if (!xJDocument.isDirty() || xJDocument.getDocumentPath() == null) continue;
                xJDocument.performSave(false);
            }
        }
    }

    protected static class ScheduledTimer
    extends TimerTask {
        protected boolean startup = true;

        protected ScheduledTimer() {
        }

        public void run() {
            for (XJScheduledTimer xJScheduledTimer : scheduledTimers) {
                xJScheduledTimer.fire(this.startup, 1L);
            }
            this.startup = false;
        }
    }
}

