/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.app.MacOS;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import javax.swing.JFrame;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.menu.XJMainMenuBar;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuBarDelegate;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.utils.XJLocalizable;
import org.antlr.xjlib.foundation.XJSystem;

public class XJApplicationMacOS
extends XJApplication
implements XJMenuBarDelegate {
    protected JFrame invisibleFrame = null;
    protected XJMainMenuBar mainMenuBar = null;

    public XJApplicationMacOS() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Application.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void handleAbout(ApplicationEvent applicationEvent) {
                XJApplicationMacOS.this.displayAbout();
                applicationEvent.setHandled(true);
            }

            public void handleOpenApplication(ApplicationEvent applicationEvent) {
            }

            public void handleOpenFile(ApplicationEvent applicationEvent) {
                XJApplicationMacOS.this.openDocument(applicationEvent.getFilename());
            }

            public void handlePreferences(ApplicationEvent applicationEvent) {
                XJApplicationMacOS.this.performPreferences();
            }

            public void handlePrintFile(ApplicationEvent applicationEvent) {
            }

            public void handleQuit(ApplicationEvent applicationEvent) {
                XJApplicationMacOS.this.performQuit();
            }
        });
    }

    protected void startup() {
        super.startup();
        if (!XJSystem.isHeadless()) {
            this.createFramelessMenuBar();
        }
    }

    protected void addPreferencesMenuItem() {
        Application.getApplication().addPreferencesMenuItem();
        Application.getApplication().setEnabledPreferencesMenu(true);
    }

    protected void removePreferencesMenuItem() {
        Application.getApplication().removePreferencesMenuItem();
    }

    private void createFramelessMenuBar() {
        this.invisibleFrame = new JFrame();
        this.invisibleFrame.setUndecorated(true);
        this.mainMenuBar = XJMainMenuBar.createInstance();
        this.mainMenuBar.createMenuBar();
        this.mainMenuBar.setDelegate(this);
        this.mainMenuBar.refreshState();
        this.invisibleFrame.setJMenuBar(this.mainMenuBar.getJMenuBar());
        this.invisibleFrame.setLocation(0, 0);
        this.invisibleFrame.setSize(0, 0);
        this.invisibleFrame.pack();
        this.invisibleFrame.setVisible(true);
    }

    public void menuItemState(XJMenuItem xJMenuItem) {
        int n = xJMenuItem.getTag();
        switch (n) {
            case 10000: {
                xJMenuItem.setTitle(XJLocalizable.getXJString("New") + (XJApplication.shared().getDocumentExtensions().size() > 1 ? "..." : ""));
            }
            case 10001: 
            case 20000: 
            case 20001: {
                xJMenuItem.setEnabled(true);
                break;
            }
            default: {
                if (XJMainMenuBar.isRecentFilesItem(xJMenuItem)) {
                    xJMenuItem.setEnabled(true);
                    break;
                }
                xJMenuItem.setEnabled(false);
            }
        }
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
    }

    public void handleMenuSelected(XJMenu xJMenu) {
    }
}

