/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.skin.syntaxdiagram;

import java.awt.Font;
import java.awt.Point;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.shape.GLink;

public class SDLink {
    public static boolean linkContainsPoint(GLink gLink, Point point) {
        GContext gContext = gLink.getContext();
        float f = gLink.source.getX();
        float f2 = gLink.source.getY();
        float f3 = gLink.source.linkDimension.getPixelWidth(gContext);
        return (float)point.x >= f && (float)point.x <= f + f3 && (float)point.y >= f2 - gContext.getPixelBoxDown() && (float)point.y <= f2 + gContext.getPixelBoxDown() + gContext.getPixelBoxUp();
    }

    public static void draw(GLink gLink) {
        GContext gContext = gLink.getContext();
        float f = gLink.source.getX();
        float f2 = gLink.source.getY();
        float f3 = gLink.target.getX();
        float f4 = gLink.target.getY();
        float f5 = gContext.getPixelValue("w");
        gContext.setColor(gContext.linkColor);
        if (gLink.transition.isEpsilon()) {
            if (gLink.virtualPosition != null) {
                SDLink.drawDownSloop(gContext, gLink, f, f2, f + f5, gLink.getVirtualY());
                gContext.drawLine(f + f5, gLink.getVirtualY(), f3 - f5, gLink.getVirtualY());
                SDLink.drawUpSloop(gContext, gLink, f3 - f5, gLink.getVirtualY(), f3, f4);
            } else if (f2 > f4) {
                if (f3 - f > f5 && f5 > 0.0f) {
                    gContext.drawLine(f, f2, f3 - f5, f2);
                    SDLink.drawUpSloop(gContext, gLink, f3 - f5, f2, f3, f4);
                } else {
                    SDLink.drawUpSloop(gContext, gLink, f, f2, f3, f4);
                }
            } else if (f4 > f2) {
                SDLink.drawDownSloop(gContext, gLink, f, f2, f3, f4);
            } else {
                gContext.drawLine(f, f2, f3, f4);
                if (gLink.target.lastNodeOfRule) {
                    gContext.drawRightArrow(f3, f4, gContext.getPixelArrowWidth(), gContext.getPixelArrowHeight());
                }
            }
        } else {
            SDLink.drawBox(gContext, gLink);
        }
    }

    public static void drawUpSloop(GContext gContext, GLink gLink, float f, float f2, float f3, float f4) {
        float f5 = f3;
        if (gLink.last) {
            float f6 = (f3 - f) / 4.0f;
            if (gLink.transition.loop) {
                gContext.drawLine(f, f2, f5 - f6, f2);
                gContext.drawArc(f5 - 2.0f * f6, f2, 2.0f * f6, 2.0f * f6, 0, 90);
                gContext.drawLine(f5, f2 + f6, f5, f4);
            } else {
                gContext.drawLine(f, f2, f5 - f6, f2);
                gContext.drawArc(f5 - 2.0f * f6, f2 - 2.0f * f6, 2.0f * f6, 2.0f * f6, 0, -90);
                gContext.drawLine(f5, f2 - f6, f5, f4);
            }
        } else {
            gContext.drawLine(f, f2, f5, f2);
            gContext.drawLine(f5, f2, f5, f4);
            gContext.drawRightArrow(f5, f2, gContext.getPixelArrowWidth(), gContext.getPixelArrowHeight());
        }
        if (!gLink.transition.loop) {
            gContext.drawUpArrow(f5, f4, gContext.getPixelArrowWidth(), gContext.getPixelArrowHeight());
        }
    }

    public static void drawDownSloop(GContext gContext, GLink gLink, float f, float f2, float f3, float f4) {
        float f5 = (f3 - f) / 4.0f;
        if (gLink.last) {
            if (gLink.transition.loop) {
                gContext.drawLine(f, f2, f, f4 + f5);
                gContext.drawArc(f, f4, 2.0f * f5, 2.0f * f5, 90, 90);
                gContext.drawLine(f + f5, f4, f3, f4);
                gContext.drawDownArrow(f, f2, gContext.getPixelArrowWidth(), gContext.getPixelArrowHeight());
            } else {
                gContext.drawLine(f, f2, f, f4 - f5);
                gContext.drawArc(f, f4 - 2.0f * f5, 2.0f * f5, 2.0f * f5, -90, -90);
                gContext.drawLine(f + f5, f4, f3, f4);
            }
        } else {
            gContext.drawLine(f, f2 + f5, f, f4);
            gContext.drawLine(f, f4, f3, f4);
        }
    }

    public static void drawBox(GContext gContext, GLink gLink) {
        Font font;
        float f = gLink.source.getX();
        float f2 = gLink.source.getY();
        float f3 = gLink.source.linkDimension.getPixelWidth(gContext);
        gContext.drawLine(f, f2, f + gContext.getPixelBoxEdge(), f2);
        gContext.drawRightArrow(f + gContext.getPixelBoxEdge(), f2, gContext.getPixelArrowWidth(), gContext.getPixelArrowHeight());
        if (gLink.transition.externalRuleRef) {
            font = gContext.getRuleFont();
            gContext.drawRoundRect(f + gContext.getPixelBoxEdge(), f2 - gContext.getPixelBoxDown(), f3 - 2.0f * gContext.getPixelBoxEdge(), gContext.getPixelBoxDown() + gContext.getPixelBoxUp(), 8.0f, 8.0f, true);
        } else {
            font = gContext.getBoxFont();
            gContext.drawRect(f + gContext.getPixelBoxEdge(), f2 - gContext.getPixelBoxDown(), f3 - 2.0f * gContext.getPixelBoxEdge(), gContext.getPixelBoxDown() + gContext.getPixelBoxUp(), true);
        }
        gContext.drawLine(f + f3 - gContext.getPixelBoxEdge(), f2, f + f3, f2);
        gContext.setColor(gContext.getColorForLabel(gLink.transition.label));
        gContext.drawString(font, gLink.transition.label, f + f3 / 2.0f, f2, 0);
    }
}

