/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.serializable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class SXMLEncoder
implements SEncoder {
    private final Map<SSerializable, Entry> cache = new HashMap<SSerializable, Entry>();
    private final Stack<Entry> stack = new Stack();
    private long uid;
    private Entry root;

    public String toString() {
        this.uid = 0L;
        XMLWriter xMLWriter = new XMLWriter();
        this.root.toXML(xMLWriter);
        return xMLWriter.toString();
    }

    public void write(SSerializable sSerializable) {
        Entry entry = this.cache.get(sSerializable);
        if (entry == null) {
            entry = new Entry(sSerializable, this.uid++);
            this.cache.put(sSerializable, entry);
            if (this.root == null) {
                this.root = entry;
                this.stack.push(this.root);
            } else {
                this.stack.peek().write(entry);
            }
            this.stack.push(entry);
            sSerializable.encode(this);
            this.stack.pop();
        } else {
            this.stack.peek().write(entry.getUID());
        }
    }

    public void write(String string) {
        this.stack.peek().write(string);
    }

    public void write(int n) {
        this.stack.peek().write(n);
    }

    public void write(boolean bl) {
        this.stack.peek().write(bl);
    }

    public static class XMLWriter {
        StringBuffer sb = new StringBuffer();
        Stack<String> elements = new Stack();

        public void open(String string) {
            this.elements.push(string);
            this.sb.append("<");
            this.sb.append(string);
            this.sb.append(">");
        }

        public void close() {
            String string = this.elements.pop();
            this.sb.append("</");
            this.sb.append(string);
            this.sb.append(">");
        }

        public void write(String string) {
            this.sb.append(string);
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    public static class Entry {
        final List<Object> stream = new ArrayList<Object>();
        final Object object;
        final long uid;

        public Entry(Object object, long l) {
            this.object = object;
            this.uid = l;
        }

        public void write(Entry entry) {
            this.stream.add(entry);
        }

        public void write(String string) {
            this.stream.add(string);
        }

        public void write(int n) {
            this.stream.add(n);
        }

        public void write(long l) {
            this.stream.add(l);
        }

        public void write(boolean bl) {
            this.stream.add(bl);
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.open(this.object.getClass().getSimpleName());
            for (Object object : this.stream) {
                if (object instanceof Entry) {
                    ((Entry)object).toXML(xMLWriter);
                    continue;
                }
                if (object == null) continue;
                String string = object.getClass().getSimpleName();
                if (object instanceof Integer) {
                    string = "int";
                }
                if (object instanceof Long) {
                    string = "long";
                }
                if (object instanceof Boolean) {
                    string = "bool";
                }
                if (object instanceof String) {
                    string = "str";
                }
                xMLWriter.open(string);
                xMLWriter.write(object.toString());
                xMLWriter.close();
            }
            xMLWriter.close();
        }

        public long getUID() {
            return this.uid;
        }
    }
}

