/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.shape;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.visualization.fa.FAState;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GNode
extends GObject
implements SSerializable {
    public FAState state;
    public List<GLink> links = new ArrayList<GLink>();
    public GPoint position;
    public GDimension nodeDimension = new GDimension("m", "z", "y");
    public GDimension linkDimension = new GDimension();
    public GDimension globalDimension;
    public boolean lastNodeOfRule = false;

    public void setContext(GContext gContext) {
        super.setContext(gContext);
        for (GLink gLink : this.links) {
            gLink.setContext(gContext);
        }
    }

    public void setState(FAState fAState) {
        this.state = fAState;
    }

    public void setPosition(GPoint gPoint) {
        this.position = new GPoint(gPoint);
    }

    public boolean containsStateNumber(int n) {
        if (this.state.stateNumber == this.state.stateNumber) {
            return true;
        }
        for (GLink gLink : this.links) {
            if (!gLink.containsStateNumber(n)) continue;
            return true;
        }
        return false;
    }

    public void addLink(GLink gLink) {
        gLink.setSource(this);
        this.links.add(gLink);
    }

    public GLink getLink(FATransition fATransition) {
        for (GLink gLink : this.links) {
            if (gLink.transition != fATransition) continue;
            return gLink;
        }
        return null;
    }

    public float getX() {
        return this.position.getX(null);
    }

    public float getY() {
        return this.position.getY(null);
    }

    public float getCenterX() {
        return this.getX() + this.nodeDimension.getPixelWidth(null) / 2.0f;
    }

    public float getCenterY() {
        return this.getY();
    }

    public float getBeginX() {
        return this.getX();
    }

    public float getBeginY() {
        return this.getY();
    }

    public float getEndX() {
        return this.getX() + this.nodeDimension.getPixelWidth(null);
    }

    public float getEndY() {
        return this.getY();
    }

    public Rectangle getBounds() {
        float f = this.globalDimension.getPixelWidth(this.context);
        float f2 = this.globalDimension.getPixelUp(this.context);
        float f3 = this.globalDimension.getPixelDown(this.context);
        int n = (int)this.getX();
        int n2 = (int)(this.getY() - f2);
        int n3 = (int)f;
        int n4 = (int)(f2 + f3);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public boolean containsPoint(Point point) {
        return this.context.objectContainsPoint(this, point);
    }

    private void cacheGlobalDimension(GContext gContext) {
        this.globalDimension = new GDimension();
        this.globalDimension.addWidth(this.nodeDimension.width + this.linkDimension.width);
        this.globalDimension.addUp(GLiteral.max(this.nodeDimension.up, this.linkDimension.up));
        this.globalDimension.addDown(GLiteral.max(this.nodeDimension.down, this.linkDimension.down));
        this.globalDimension.cache(gContext);
    }

    public void render(float f, float f2) {
        this.position.cache(this.context, f, f2);
        this.nodeDimension.cache(this.context);
        this.linkDimension.cache(this.context);
        this.cacheGlobalDimension(this.context);
        for (GLink gLink : this.links) {
            gLink.render(f, f2);
        }
    }

    public void draw() {
        this.context.drawNode(this);
        if (this.context.drawnode) {
            this.context.setColor(Color.red);
            this.context.fillRect(this.getX() - 1.0f, this.getY() - 1.0f, 3.0f, 3.0f);
        }
    }

    public void drawNodeAndLink() {
        for (GLink gLink : this.links) {
            gLink.draw();
        }
        this.draw();
        if (this.context.drawdimension) {
            this.context.setColor(Color.lightGray);
            float f = this.globalDimension.getPixelWidth(this.context);
            float f2 = this.globalDimension.getPixelUp(this.context);
            float f3 = this.globalDimension.getPixelDown(this.context);
            if (f2 + f3 > 0.0f) {
                this.context.drawRect(this.getX(), this.getY() - f2, f, f2 + f3, false);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.state.stateNumber);
    }

    public void encode(SEncoder sEncoder) {
        sEncoder.write(this.state);
        for (GLink gLink : this.links) {
            sEncoder.write(gLink);
        }
        sEncoder.write(this.lastNodeOfRule);
    }
}

