/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.shape;

import java.awt.Point;
import java.awt.Rectangle;
import org.antlr.works.visualization.fa.FATransition;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.primitive.GDimension;
import org.antlr.works.visualization.graphics.primitive.GPoint;
import org.antlr.works.visualization.graphics.shape.GNode;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GLink
extends GObject
implements SSerializable {
    public FATransition transition;
    public GNode source;
    public GNode target;
    public GDimension branchDim;
    public GPoint virtualPosition;
    public boolean last = false;

    public GLink() {
    }

    public GLink(FATransition fATransition, GNode gNode) {
        this.transition = fATransition;
        this.target = gNode;
    }

    public void setSource(GNode gNode) {
        this.source = gNode;
    }

    public void setVirtualPosition(GPoint gPoint) {
        this.virtualPosition = new GPoint(gPoint);
    }

    public void setBranchDimension(GDimension gDimension) {
        this.branchDim = new GDimension(gDimension);
    }

    public void setLast(boolean bl) {
        this.last = bl;
    }

    public float getVirtualY() {
        return this.virtualPosition.getY(null);
    }

    public boolean containsStateNumber(int n) {
        return this.transition.containsStateNumber(n);
    }

    public boolean containsPoint(Point point) {
        return this.context.objectContainsPoint(this, point);
    }

    public void render(float f, float f2) {
        if (this.branchDim != null) {
            this.branchDim.cache(this.context);
        }
        if (this.virtualPosition != null) {
            this.virtualPosition.cache(this.context, f, f2);
        }
    }

    public Rectangle getBounds() {
        int n = (int)this.source.getBeginX();
        int n2 = (int)this.source.getBeginY();
        int n3 = (int)this.target.getEndX();
        int n4 = (int)this.target.getEndY();
        return new Rectangle(n, n2, Math.max(1, n3 - n), Math.max(1, n4 - n2));
    }

    public void draw() {
        this.context.drawLink(this);
    }

    public void encode(SEncoder sEncoder) {
        sEncoder.write(this.transition);
        sEncoder.write(this.source);
        sEncoder.write(this.target);
        sEncoder.write(this.last);
    }
}

