/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.primitive;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLiteral {
    public static final String OP_SUB = "-";
    public static final String OP_MAX = "#";
    public static final String OP_LPAREN = "(";
    public static final String OP_RPAREN = ")";
    public static final String OP_COMA = ",";
    public static final String OP_NULL = "!";

    public static String substract(String string, String string2) {
        return string + OP_SUB + OP_LPAREN + string2 + OP_RPAREN;
    }

    public static String add(String string, String string2) {
        return string + string2;
    }

    public static String max(String string, String string2) {
        boolean bl;
        boolean bl2 = string == null || string.length() == 0;
        boolean bl3 = bl = string2 == null || string2.length() == 0;
        if (bl2 && bl) {
            return "";
        }
        if (bl2) {
            return string2;
        }
        if (bl) {
            return string;
        }
        return "#(" + string + OP_COMA + string2 + OP_RPAREN;
    }

    public static float evaluate(String string, Map<String, Float> map) {
        if (string == null) {
            return 0.0f;
        }
        return new Evaluator(string, map).evaluate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Evaluator {
        public String s;
        public Map<String, Float> values;
        public int position;

        public Evaluator(String string, Map<String, Float> map) {
            this.s = string;
            this.values = map;
        }

        public float evaluate() {
            this.position = 0;
            return this.eval();
        }

        private float eval() {
            float f = 0.0f;
            do {
                Float f2;
                if ((f2 = this.values.get(this.c())) != null) {
                    f += f2.floatValue();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_SUB)) {
                    f -= this.evaluate_sub();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_MAX)) {
                    f += this.evaluate_max();
                    continue;
                }
                if (this.c().equals(GLiteral.OP_RPAREN) || this.c().equals(GLiteral.OP_COMA)) break;
                System.err.println("** Evaluator: unexpected token \"" + this.c() + "\"");
            } while (this.nextChar());
            return f;
        }

        private float evaluate_sub() {
            this.match(GLiteral.OP_SUB);
            this.match(GLiteral.OP_LPAREN);
            return this.eval();
        }

        private float evaluate_max() {
            this.match(GLiteral.OP_MAX);
            this.match(GLiteral.OP_LPAREN);
            float f = this.eval();
            this.match(GLiteral.OP_COMA);
            float f2 = this.eval();
            return Math.max(f, f2);
        }

        private boolean nextChar() {
            ++this.position;
            return this.position < this.s.length();
        }

        private void match(String string) {
            if (this.c().equals(string)) {
                this.nextChar();
            } else {
                System.err.println("** Evaluator: unexpected token \"" + this.c() + "\"");
            }
        }

        private String c() {
            return this.s.substring(this.position, this.position + 1);
        }
    }
}

