/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.primitive;

import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.primitive.GLiteral;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.serializable.SSerializable;

public class GDimension
implements SSerializable {
    public String width = "";
    public String up = "";
    public String down = "";
    private float cacheWidth = Float.MIN_VALUE;
    private float cacheUp = Float.MIN_VALUE;
    private float cacheDown = Float.MIN_VALUE;

    public GDimension() {
    }

    public GDimension(GDimension gDimension) {
        this.width = gDimension.width;
        this.up = gDimension.up;
        this.down = gDimension.down;
    }

    public GDimension(String string, String string2, String string3) {
        this.width = string;
        this.up = string2;
        this.down = string3;
    }

    public void addWidth(String string) {
        this.width = GLiteral.add(this.width, string);
    }

    public void addUp(String string) {
        this.up = GLiteral.add(this.up, string);
    }

    public void addDown(String string) {
        this.down = GLiteral.add(this.down, string);
    }

    public void maxWidth(String string) {
        this.width = GLiteral.max(this.width, string);
    }

    public void maxUp(String string) {
        this.up = GLiteral.max(this.up, string);
    }

    public void maxDown(String string) {
        this.down = GLiteral.max(this.down, string);
    }

    public float getPixelWidth(GContext gContext) {
        if (this.cacheWidth == Float.MIN_VALUE) {
            return gContext.getPixelValue(this.width);
        }
        return this.cacheWidth;
    }

    public float getPixelUp(GContext gContext) {
        if (this.cacheUp == Float.MIN_VALUE) {
            return gContext.getPixelValue(this.up);
        }
        return this.cacheUp;
    }

    public float getPixelDown(GContext gContext) {
        if (this.cacheDown == Float.MIN_VALUE) {
            return gContext.getPixelValue(this.down);
        }
        return this.cacheDown;
    }

    public float getPixelHeight(GContext gContext) {
        return this.getPixelUp(gContext) + this.getPixelDown(gContext);
    }

    public void cache(GContext gContext) {
        this.cacheWidth = gContext.getPixelValue(this.width);
        this.cacheUp = gContext.getPixelValue(this.up);
        this.cacheDown = gContext.getPixelValue(this.down);
    }

    public String toString() {
        return "{ " + this.width + ", " + this.up + "|" + this.down + " }";
    }

    public void encode(SEncoder sEncoder) {
        sEncoder.write(this.width);
        sEncoder.write(this.up);
        sEncoder.write(this.down);
    }
}

