/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPathGroup
extends GObject {
    public static final String NOTIF_CURRENT_PATH_DID_CHANGE = "NOTIF_CURRENT_PATH_DID_CHANGE";
    public static int DEFAULT_PATH_WIDTH = 1;
    protected List<GPath> graphicPaths = new ArrayList<GPath>();
    protected int selectedPathIndex = 0;
    protected boolean showRuleLinks = true;

    public void addPath(GPath gPath) {
        this.graphicPaths.add(gPath);
    }

    public List<GPath> getPaths() {
        return this.graphicPaths;
    }

    public GPath getPath(int n) {
        return this.graphicPaths.get(n);
    }

    public int getNumberOfPaths() {
        return this.graphicPaths.size();
    }

    public void setSelectedPath(int n) {
        this.selectedPathIndex = n < 0 ? this.graphicPaths.size() - 1 : (n >= this.graphicPaths.size() ? 0 : n);
        this.updateShowRuleLinks();
        XJNotificationCenter.defaultCenter().postNotification(this, NOTIF_CURRENT_PATH_DID_CHANGE);
    }

    public void setPathVisible(int n, boolean bl) {
        this.getPath(n).setVisible(bl);
    }

    public boolean isPathVisible(int n) {
        return this.getPath(n).isVisible();
    }

    public void makeSureCurrentPathIsVisible() {
        if (this.getCurrentPath().isVisible()) {
            return;
        }
        for (GPath gPath : this.graphicPaths) {
            if (!gPath.isVisible()) continue;
            this.setSelectedPath(this.graphicPaths.indexOf(gPath));
            break;
        }
    }

    public void selectPreviousPath() {
        this.setSelectedPath(this.selectedPathIndex - 1);
    }

    public void selectNextPath() {
        this.setSelectedPath(this.selectedPathIndex + 1);
    }

    public GPath getCurrentPath() {
        if (this.graphicPaths.size() > 0) {
            return this.graphicPaths.get(this.selectedPathIndex);
        }
        return null;
    }

    public int getSelectedPathIndex() {
        return this.selectedPathIndex;
    }

    @Override
    public void setContext(GContext gContext) {
        super.setContext(gContext);
        for (GPath gPath : this.graphicPaths) {
            gPath.setContext(gContext);
        }
    }

    public void toggleShowRuleLinks() {
        this.showRuleLinks = !this.showRuleLinks;
        this.updateShowRuleLinks();
    }

    public void updateShowRuleLinks() {
        for (GPath gPath : this.graphicPaths) {
            gPath.setShowRuleLinks(this.showRuleLinks);
        }
    }

    public void selectPath(Point point) {
        List<GPath> list = this.getPathsAtPoint(point);
        if (list.isEmpty()) {
            return;
        }
        GPath gPath = list.get(0);
        if (list.size() > 1) {
            int n = 1;
            while (!gPath.isVisible() && n < list.size()) {
                gPath = list.get(n++);
            }
        }
        this.setSelectedPath(this.graphicPaths.indexOf(gPath));
        this.getCurrentPath().setMaxWidth();
        this.context.repaint();
    }

    public List<GPath> getPathsAtPoint(Point point) {
        ArrayList<GPath> arrayList = new ArrayList<GPath>();
        for (GPath gPath : this.graphicPaths) {
            if (!gPath.containsPoint(point)) continue;
            arrayList.add(gPath);
        }
        return arrayList;
    }

    @Override
    public void draw() {
        GPath gPath = this.getCurrentPath();
        for (GPath gPath2 : this.graphicPaths) {
            if (gPath2 != gPath) {
                gPath2.deselectElement();
            } else {
                gPath.selectElement();
            }
            if (!gPath2.isVisible() || gPath2 == gPath) continue;
            gPath2.draw(DEFAULT_PATH_WIDTH, null);
        }
        if (gPath.isVisible()) {
            gPath.draw(DEFAULT_PATH_WIDTH, null);
        }
    }

    public void drawSelectedElement() {
        if (this.getCurrentPath().isVisible() && this.getCurrentPath().isSelectable()) {
            this.getCurrentPath().drawSelectedElement();
        }
    }
}

