/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.shape.GLink;
import org.antlr.works.visualization.graphics.shape.GNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPathElement
extends GObject {
    public GObject nodeOrLink;
    public GObject source;
    public GNode target;
    public boolean isRuleLink = false;

    public static GPathElement createLink(GNode gNode, GNode gNode2) {
        GPathElement gPathElement = new GPathElement(gNode, gNode2);
        gPathElement.setRuleLink(true);
        return gPathElement;
    }

    public static GPathElement createElement(GObject gObject) {
        return new GPathElement(gObject);
    }

    public GPathElement(GObject gObject) {
        this.nodeOrLink = gObject;
    }

    public GPathElement(GObject gObject, GNode gNode) {
        this.source = gObject;
        this.target = gNode;
    }

    @Override
    public void setContext(GContext gContext) {
        super.setContext(gContext);
        if (this.nodeOrLink != null) {
            this.nodeOrLink.setContext(gContext);
        }
        if (this.source != null) {
            this.source.setContext(gContext);
        }
        if (this.target != null) {
            this.target.setContext(gContext);
        }
    }

    @Override
    public boolean containsPoint(Point point) {
        if (this.nodeOrLink != null) {
            return this.nodeOrLink.containsPoint(point);
        }
        return false;
    }

    public void setRuleLink(boolean bl) {
        this.isRuleLink = bl;
    }

    public boolean isVisible() {
        if (this.nodeOrLink != null) {
            return this.context.isObjectVisible(this.nodeOrLink);
        }
        return true;
    }

    public Set<GObject> getObjects() {
        HashSet<GObject> hashSet = new HashSet<GObject>();
        if (this.nodeOrLink != null) {
            hashSet.add(this.nodeOrLink);
        }
        if (this.source != null) {
            hashSet.add(this.source);
        }
        if (this.target != null) {
            hashSet.add(this.target);
        }
        return hashSet;
    }

    protected Point2D getBeginPoint() {
        float f;
        float f2;
        if (this.source instanceof GNode) {
            GNode gNode = (GNode)this.source;
            f2 = gNode.getCenterX();
            f = gNode.getCenterY();
        } else {
            GLink gLink = (GLink)this.source;
            f2 = gLink.target.getBeginX();
            f = gLink.target.getBeginY();
        }
        return new Point2D.Float(f2, f);
    }

    @Override
    public Rectangle getBounds() {
        if (this.nodeOrLink != null) {
            return this.nodeOrLink.getBounds();
        }
        Point2D point2D = this.getBeginPoint();
        int n = (int)point2D.getX();
        int n2 = (int)point2D.getY();
        int n3 = (int)this.target.getCenterX();
        int n4 = (int)this.target.getCenterY();
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    @Override
    public void draw() {
        if (this.nodeOrLink != null) {
            this.nodeOrLink.draw();
        }
        if (this.source != null && this.target != null) {
            Point2D point2D = this.getBeginPoint();
            this.context.setColor(this.context.linkColor);
            this.context.drawSpline((float)point2D.getX(), (float)point2D.getY(), this.target.getCenterX(), this.target.getCenterY(), 0.0f, this.context.getEndOffset(), 0.0f, true);
        }
    }
}

