/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.path;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GObject;
import org.antlr.works.visualization.graphics.path.GPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPath
extends GObject {
    public static int MIN_PATH_BLINK_WIDTH = 2;
    public static int MAX_PATH_BLINK_WIDTH = 4;
    protected List<GPathElement> elements;
    protected boolean disabled = false;
    protected boolean visible = false;
    protected boolean selectable = true;
    protected int currentIndex = -1;
    protected float step = 0.2f;
    protected float currentLineWidth = 1.0f;
    protected boolean showRuleLinks = true;

    public GPath() {
    }

    public GPath(List<GPathElement> list, boolean bl) {
        this.elements = list;
        this.disabled = bl;
    }

    @Override
    public void setContext(GContext gContext) {
        super.setContext(gContext);
        for (GPathElement gPathElement : this.elements) {
            gPathElement.setContext(gContext);
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setShowRuleLinks(boolean bl) {
        this.showRuleLinks = bl;
    }

    public int getNumberOfVisibleElements() {
        int n = 0;
        for (GPathElement gPathElement : this.elements) {
            if (!gPathElement.isVisible()) continue;
            ++n;
        }
        return n;
    }

    public void draw(float f, List list) {
        if (this.showRuleLinks) {
            this.drawElements(f, list, true);
        }
        this.drawElements(f, list, false);
    }

    public void drawElements(float f, List list, boolean bl) {
        this.context.linkColor = this.context.nodeColor = this.disabled ? Color.red : Color.green.darker();
        this.context.setLineWidth(f);
        for (GPathElement gPathElement : this.elements) {
            if (list != null && list.contains(gPathElement) || !gPathElement.isVisible() || gPathElement.isRuleLink && !bl || bl && !gPathElement.isRuleLink) continue;
            gPathElement.draw();
        }
    }

    public void drawSelectedElement() {
        if (this.currentIndex == -1) {
            return;
        }
        this.context.linkColor = this.context.nodeColor = this.disabled ? Color.red : Color.green.darker();
        this.context.setLineWidth(this.currentLineWidth);
        GPathElement gPathElement = this.elements.get(this.currentIndex);
        gPathElement.draw();
    }

    public Rectangle getBoundsOfSelectedElement() {
        if (this.currentIndex == -1) {
            return null;
        }
        GPathElement gPathElement = this.elements.get(this.currentIndex);
        return gPathElement.getBounds();
    }

    @Override
    public boolean containsPoint(Point point) {
        for (GPathElement gPathElement : this.elements) {
            if (!gPathElement.containsPoint(point)) continue;
            return true;
        }
        return false;
    }

    public Set<GObject> getObjects() {
        HashSet<GObject> hashSet = new HashSet<GObject>();
        for (GPathElement gPathElement : this.elements) {
            hashSet.addAll(gPathElement.getObjects());
        }
        return hashSet;
    }

    public boolean isCurrentElementVisible() {
        GPathElement gPathElement = this.elements.get(this.currentIndex);
        if (gPathElement.isRuleLink) {
            return this.showRuleLinks;
        }
        return gPathElement.isVisible();
    }

    public void setMaxWidth() {
        this.currentLineWidth = MAX_PATH_BLINK_WIDTH;
    }

    public void setMinWidth() {
        this.currentLineWidth = MIN_PATH_BLINK_WIDTH;
    }

    public void incrementWidth() {
        this.currentLineWidth += this.step;
        if (this.currentLineWidth >= (float)MAX_PATH_BLINK_WIDTH || this.currentLineWidth <= (float)MIN_PATH_BLINK_WIDTH) {
            this.step = -this.step;
        }
    }

    public void selectElement() {
        if (this.currentIndex == -1) {
            this.nextElement();
        }
    }

    public void deselectElement() {
        this.currentIndex = -1;
    }

    public void nextElement() {
        if (this.elements.isEmpty()) {
            this.currentIndex = -1;
            return;
        }
        int n = this.currentIndex;
        do {
            ++this.currentIndex;
            if (this.currentIndex >= this.elements.size()) {
                this.currentIndex = 0;
            }
            if (n == -1) {
                n = 0;
                continue;
            }
            if (n == this.currentIndex) break;
        } while (!this.isCurrentElementVisible());
        this.currentLineWidth = 3.0f;
        this.context.repaint();
    }

    public void previousElement() {
        if (this.elements.isEmpty()) {
            this.currentIndex = -1;
            return;
        }
        int n = this.currentIndex;
        do {
            --this.currentIndex;
            if (this.currentIndex < 0) {
                this.currentIndex = this.elements.size() - 1;
            }
            if (n == -1) {
                n = 0;
                continue;
            }
            if (n == this.currentIndex) break;
        } while (!this.isCurrentElementVisible());
        this.currentLineWidth = 3.0f;
        this.context.repaint();
    }

    public void firstElement() {
        this.currentIndex = -1;
        this.nextElement();
    }

    public void lastElement() {
        this.currentIndex = this.elements.size();
        this.previousElement();
    }
}

