/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;
import org.antlr.works.visualization.graphics.panel.GPanel;
import org.antlr.works.visualization.graphics.path.GPath;
import org.antlr.works.visualization.graphics.path.GPathGroup;
import org.antlr.xjlib.appkit.menu.XJMenu;
import org.antlr.xjlib.appkit.menu.XJMenuItem;
import org.antlr.xjlib.appkit.menu.XJMenuItemDelegate;
import org.antlr.xjlib.appkit.utils.XJSmoothScrolling;

public class GView
extends JPanel
implements XJMenuItemDelegate {
    protected boolean useCachedImage = true;
    protected boolean cachedImageRerender = false;
    protected boolean cachedImageResize = false;
    protected String placeholder;
    protected BufferedImage cachedImage = null;
    protected Dimension outOfMemoryDimension = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected List graphs = new ArrayList();
    protected int currentGraphIndex = 0;
    protected GPanel panel;
    protected GContext context;
    protected XJSmoothScrolling smoothScrolling;
    protected Point lastMouse;
    protected static final Font DEFAULT_FONT = new Font("Courier", 1, 18);
    public int offset_x = 10;
    public int offset_y = 10;
    public int prev_offset_x = 0;
    public int prev_offset_y = 0;

    public GView(GPanel gPanel, GContext gContext) {
        this.panel = gPanel;
        this.context = gContext;
        this.context.setContainer(this);
        this.smoothScrolling = new XJSmoothScrolling(this, null);
        this.setFocusable(true);
        this.setBackground(Color.white);
        this.adjustSize();
        this.addMouseMotionListener(new DefaultMouseMotionListener());
        this.addMouseListener(new DefaultMouseListener());
        this.addKeyListener(new DefaultKeyListener());
    }

    public void setEnable(boolean bl) {
        for (Object e : this.graphs) {
            GGraphAbstract gGraphAbstract = (GGraphAbstract)e;
            gGraphAbstract.setEnable(bl);
        }
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public void setGraphs(List list) {
        this.graphs.clear();
        if (list == null) {
            return;
        }
        this.graphs.addAll(list);
        if (this.currentGraphIndex >= list.size()) {
            this.currentGraphIndex = list.size() - 1;
        }
        this.applyContext();
    }

    public List getGraphs() {
        return this.graphs;
    }

    public void applyContext() {
        for (Object e : this.graphs) {
            GGraphAbstract gGraphAbstract = (GGraphAbstract)e;
            gGraphAbstract.setContext(this.context);
        }
    }

    public void setCacheEnabled(boolean bl) {
        if (this.useCachedImage != bl) {
            this.useCachedImage = bl;
            this.cacheInvalidate();
        }
    }

    public boolean isCachedEnabled() {
        return this.useCachedImage;
    }

    public void cacheInvalidate() {
        this.cachedImage = null;
    }

    public void cacheRerender() {
        this.cachedImageRerender = true;
    }

    public void setCacheResizeImage(boolean bl) {
        this.cachedImageResize = bl;
    }

    public BufferedImage getImage() {
        if (this.getCurrentGraph() == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.getPaintWidth(), this.getPaintHeight(), 5);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getPaintWidth(), this.getPaintHeight());
        this.render(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public boolean setNextGraph() {
        ++this.currentGraphIndex;
        if (this.currentGraphIndex >= this.graphs.size()) {
            this.currentGraphIndex = this.graphs.size() - 1;
            return false;
        }
        return true;
    }

    public boolean setPrevGraph() {
        --this.currentGraphIndex;
        if (this.currentGraphIndex < 0) {
            this.currentGraphIndex = 0;
            return false;
        }
        return true;
    }

    public int getCurrentGraphIndex() {
        return this.currentGraphIndex;
    }

    public GGraphAbstract getCurrentGraph() {
        if (this.graphs.size() > 0) {
            return (GGraphAbstract)this.graphs.get(this.currentGraphIndex);
        }
        return null;
    }

    public GGraphGroup getCurrentGraphGroup() {
        return (GGraphGroup)this.getCurrentGraph();
    }

    public GPathGroup getCurrentPathGroup() {
        return this.getCurrentGraphGroup().pathGroup;
    }

    public GPath getCurrentPath() {
        return this.getCurrentPathGroup().getCurrentPath();
    }

    public void refresh() {
        if (this.getCurrentGraph() != null) {
            this.getCurrentGraph().render(0.0f, 0.0f);
        }
        this.cacheInvalidate();
        this.adjustSize();
        this.repaint();
    }

    public void refreshSizeChanged(boolean bl) {
        if (this.useCachedImage) {
            this.setCacheResizeImage(bl);
            if (!bl) {
                if (this.getCurrentGraph() != null) {
                    this.getCurrentGraph().render(0.0f, 0.0f);
                }
                this.cacheInvalidate();
            }
            this.adjustSize();
            this.repaint();
        } else {
            this.refresh();
        }
    }

    public void adjustSize() {
        if (this.getCurrentGraph() == null || this.context == null) {
            return;
        }
        Dimension dimension = new Dimension(this.getGraphWidth() + 2 * this.offset_x, this.getGraphHeight() + 2 * this.offset_y);
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    public int getGraphWidth() {
        if (this.getCurrentGraph().getDimension() == null) {
            return 400;
        }
        return (int)this.getCurrentGraph().getWidth() + 20;
    }

    public int getGraphHeight() {
        if (this.getCurrentGraph().getDimension() == null) {
            return 200;
        }
        return (int)this.getCurrentGraph().getHeight() + 20;
    }

    public void addMenuItem(JPopupMenu jPopupMenu, String string, int n, Object object) {
        XJMenuItem xJMenuItem = new XJMenuItem();
        xJMenuItem.setTitle(string);
        xJMenuItem.setTag(n);
        xJMenuItem.setObject(object);
        xJMenuItem.setDelegate(this);
        jPopupMenu.add(xJMenuItem.getSwingComponent());
    }

    public JPopupMenu getContextualMenu() {
        return null;
    }

    public void handleMenuEvent(XJMenu xJMenu, XJMenuItem xJMenuItem) {
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.getContextualMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void pathCurrentElementDidChange() {
        GPath gPath = this.getCurrentPath();
        Rectangle rectangle = gPath.getBoundsOfSelectedElement();
        if (!rectangle.isEmpty()) {
            rectangle.x -= 50;
            rectangle.y -= 50;
            rectangle.width += 100;
            rectangle.height += 100;
            this.smoothScrolling.scrollTo(rectangle);
        }
    }

    public boolean canDraw() {
        return this.getCurrentGraph() != null && this.getCurrentGraph().getDimension() != null && this.getCurrentGraph().isRendered();
    }

    public void render(Graphics2D graphics2D) {
        this.context.offsetX = this.offset_x;
        this.context.offsetY = this.offset_y;
        this.context.setGraphics2D(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.getCurrentGraph().draw();
    }

    public int getPaintWidth() {
        return this.getGraphWidth() + this.offset_x;
    }

    public int getPaintHeight() {
        return this.getGraphHeight() + this.offset_y + 1;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.canDraw()) {
            this.paintPlaceholder(graphics);
            return;
        }
        int n = this.getPaintWidth();
        int n2 = this.getPaintHeight();
        if (this.useCachedImage) {
            boolean bl;
            boolean bl2 = bl = this.cachedImage != null && (this.cachedImage.getWidth() != n || this.cachedImage.getHeight() != n2);
            if (bl && !this.cachedImageResize && this.cachedImage != null) {
                this.cachedImage.flush();
                this.cachedImage = null;
            }
            if (this.cachedImage == null) {
                if (n < this.outOfMemoryDimension.width && n2 < this.outOfMemoryDimension.height) {
                    try {
                        this.cachedImage = new BufferedImage(n, n2, 5);
                        Graphics2D graphics2D = (Graphics2D)this.cachedImage.getGraphics();
                        graphics2D.setColor(Color.white);
                        graphics2D.fillRect(0, 0, n, n2);
                        this.render(graphics2D);
                        graphics2D.dispose();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.outOfMemoryDimension.width = n;
                        this.outOfMemoryDimension.height = n2;
                        this.cachedImage = null;
                        System.err.println("Out of memory, disabling cache (" + (int)((double)(n * n2) * 3.0 / 1048576.0) + " Mb)");
                    }
                }
            } else if (this.cachedImageRerender) {
                Graphics2D graphics2D = (Graphics2D)this.cachedImage.getGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, n, n2);
                this.render(graphics2D);
                graphics2D.dispose();
                this.cachedImageRerender = false;
            }
        }
        if (this.cachedImage == null) {
            this.render((Graphics2D)graphics);
        } else {
            graphics.drawImage(this.cachedImage, 0, 0, n, n2, null);
        }
        if (!this.cachedImageResize && this.getCurrentGraph() instanceof GGraphGroup) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.context.offsetX = this.offset_x;
            this.context.offsetY = this.offset_y;
            this.context.setGraphics2D(graphics2D);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.getCurrentPathGroup().drawSelectedElement();
        }
    }

    public void paintPlaceholder(Graphics graphics) {
        if (this.placeholder == null) {
            return;
        }
        graphics.setFont(DEFAULT_FONT);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = this.getVisibleRect();
        int n = rectangle.x + rectangle.width / 2 - fontMetrics.stringWidth(this.placeholder) / 2;
        int n2 = rectangle.y + rectangle.height / 2 + fontMetrics.getHeight() / 2;
        graphics.setColor(Color.gray);
        graphics.drawString(this.placeholder, n, n2);
    }

    public class DefaultKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            if (GView.this.getCurrentGraph() instanceof GGraphGroup) {
                this.handleKeyPressedInGraphGroup(keyEvent);
            }
        }

        public void handleKeyPressedInGraphGroup(KeyEvent keyEvent) {
            GPath gPath = GView.this.getCurrentPath();
            switch (keyEvent.getKeyCode()) {
                case 39: {
                    gPath.nextElement();
                    GView.this.pathCurrentElementDidChange();
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    gPath.previousElement();
                    GView.this.pathCurrentElementDidChange();
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    gPath.lastElement();
                    GView.this.pathCurrentElementDidChange();
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    gPath.firstElement();
                    GView.this.pathCurrentElementDidChange();
                    keyEvent.consume();
                    break;
                }
                case 65: {
                    GView.this.getCurrentPathGroup().toggleShowRuleLinks();
                    GView.this.cacheRerender();
                    keyEvent.consume();
                }
            }
            if (keyEvent.isConsumed()) {
                GView.this.repaint();
            }
        }
    }

    public class DefaultMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!GView.this.isFocusOwner()) {
                GView.this.requestFocusInWindow();
            }
            GView.this.setCacheEnabled(false);
            GView.this.prev_offset_x = GView.this.offset_x;
            GView.this.prev_offset_y = GView.this.offset_y;
            GView.this.lastMouse = mouseEvent.getPoint();
            if (GView.this.getCurrentGraph() instanceof GGraphGroup) {
                this.handleMousePressedInGraphGroup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            GView.this.lastMouse = null;
            GView.this.setCacheEnabled(true);
            GView.this.repaint();
        }

        public void handleMousePressedInGraphGroup(MouseEvent mouseEvent) {
            GView.this.getCurrentPathGroup().selectPath(mouseEvent.getPoint());
        }
    }

    public class DefaultMouseMotionListener
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            if (GView.this.lastMouse == null) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = point.x - GView.this.lastMouse.x;
            int n2 = point.y - GView.this.lastMouse.y;
            GView.this.offset_x = GView.this.prev_offset_x + n;
            GView.this.offset_y = GView.this.prev_offset_y + n2;
            GView.this.refresh();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

